/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.google.errorprone.annotations.InlineMe;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.expression.ExpressionEnvironment;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.ScaleAndTranslateTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.world.registry.LegacyMapper;

public class WorldEditExpressionEnvironment
implements ExpressionEnvironment {
    private final Transform transform;
    private Vector3 current = Vector3.ZERO;
    private final Extent extent;

    @Deprecated
    @InlineMe(replacement="this(extent, new ScaleAndTranslateTransform(zero, unit))", imports={"com.sk89q.worldedit.math.transform.ScaleAndTranslateTransform"})
    public WorldEditExpressionEnvironment(Extent extent, Vector3 unit, Vector3 zero) {
        this(extent, new ScaleAndTranslateTransform(zero, unit));
    }

    public WorldEditExpressionEnvironment(Extent extent, Transform transform) {
        this.extent = extent;
        this.transform = transform;
    }

    public BlockVector3 toWorld(double x, double y, double z) {
        return this.transform.apply(Vector3.at(x, y, z)).add(0.5, 0.5, 0.5).toBlockPoint();
    }

    public Vector3 toWorldRel(double x, double y, double z) {
        return this.current.add(x, y, z);
    }

    private int getLegacy(BlockVector3 position, int index) {
        int[] legacy = LegacyMapper.getInstance().getLegacyFromBlock(this.extent.getBlock(position).toImmutableState());
        return legacy == null ? 0 : legacy[index];
    }

    @Override
    public int getBlockType(double x, double y, double z) {
        return this.getLegacy(this.toWorld(x, y, z), 0);
    }

    @Override
    public int getBlockData(double x, double y, double z) {
        return this.getLegacy(this.toWorld(x, y, z), 1);
    }

    @Override
    public int getBlockTypeAbs(double x, double y, double z) {
        return this.getLegacy(BlockVector3.at(x, y, z), 0);
    }

    @Override
    public int getBlockDataAbs(double x, double y, double z) {
        return this.getLegacy(BlockVector3.at(x, y, z), 1);
    }

    @Override
    public int getBlockTypeRel(double x, double y, double z) {
        return this.getLegacy(this.toWorldRel(x, y, z).toBlockPoint(), 0);
    }

    @Override
    public int getBlockDataRel(double x, double y, double z) {
        return this.getLegacy(this.toWorldRel(x, y, z).toBlockPoint(), 1);
    }

    public void setCurrentBlock(Vector3 current) {
        this.current = current;
    }
}

