/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.selector;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.regions.selector.limit.SelectorLimits;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.util.List;
import javax.annotation.Nullable;

public class ExtendingPolygonal2DRegionSelector
extends Polygonal2DRegionSelector {
    public ExtendingPolygonal2DRegionSelector() {
        super((World)null);
    }

    public ExtendingPolygonal2DRegionSelector(@Nullable World world) {
        super(world);
    }

    public ExtendingPolygonal2DRegionSelector(RegionSelector oldSelector) {
        super(oldSelector);
    }

    public ExtendingPolygonal2DRegionSelector(@Nullable World world, List<BlockVector2> points, int minY, int maxY) {
        super(world, points, minY, maxY);
    }

    private static double distanceFromLine(Vector2 position, Vector2 start, Vector2 end) {
        Vector2 difference = end.subtract(start);
        double length = difference.length();
        Vector2 normalizedDifference = difference.divide(length);
        double determinant = position.subtract(start).dot(normalizedDifference);
        if (determinant <= 0.0) {
            return position.distance(start);
        }
        if (determinant >= length) {
            return position.distance(end);
        }
        Vector2 normalizedNormal = new Vector2(-normalizedDifference.z(), normalizedDifference.x());
        return Math.abs(position.subtract(start).dot(normalizedNormal));
    }

    @Override
    public boolean selectSecondary(BlockVector3 position, SelectorLimits limits) {
        if (this.region.size() < 3) {
            return super.selectSecondary(position, limits);
        }
        BlockVector2 blockPosition2D = position.toBlockVector2();
        Vector2 position2D = blockPosition2D.toVector2();
        List<BlockVector2> points = this.region.getPoints();
        double minDistance = 2.147483647E9;
        int insertBeforeIndex = -1;
        Vector2 previousPoint = points.getLast().toVector2();
        for (int i = 0; i < points.size(); ++i) {
            BlockVector2 blockPoint = points.get(i);
            if (blockPoint.equals(blockPosition2D)) {
                return false;
            }
            Vector2 point = blockPoint.toVector2();
            double currentDistance = ExtendingPolygonal2DRegionSelector.distanceFromLine(position2D, previousPoint, point);
            if (currentDistance < minDistance) {
                minDistance = currentDistance;
                insertBeforeIndex = i;
            }
            previousPoint = point;
        }
        assert (insertBeforeIndex >= 0);
        this.region.addPoint(insertBeforeIndex, blockPosition2D);
        this.region.expandY(position.y());
        return true;
    }

    @Override
    public void explainSecondarySelection(Actor player, LocalSession session, BlockVector3 pos) {
        player.printInfo(TranslatableComponent.of("worldedit.selection.polygon2d.explain.secondary", TextComponent.of(this.region.size()), TextComponent.of(pos.toString())));
        this.explainRegionAdjust(player, session);
    }
}

