/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class RecursiveDirectoryWatcher
implements Closeable {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Path root;
    private final WatchService watchService;
    private Thread watchThread;
    private Consumer<DirEntryChangeEvent> eventConsumer;
    private final BiMap<WatchKey, Path> watchRootMap = HashBiMap.create();

    private RecursiveDirectoryWatcher(Path root, WatchService watchService) {
        this.root = root;
        this.watchService = watchService;
    }

    public static RecursiveDirectoryWatcher create(Path root) throws IOException {
        WatchService watchService;
        try {
            watchService = root.getFileSystem().newWatchService();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("Root must support file watching", e);
        }
        return new RecursiveDirectoryWatcher(root, watchService);
    }

    private void registerFolderWatcher(Path root) throws IOException {
        WatchKey watchKey = root.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        LOGGER.debug("Watch registered: " + String.valueOf(root));
        this.watchRootMap.put((Object)watchKey, (Object)root);
    }

    private void triggerInitialEvents(Path root) throws IOException, FilenameException {
        Path schematicRoot = WorldEdit.getInstance().getSchematicsManager().getRoot();
        this.eventConsumer.accept(new DirectoryCreatedEvent(root));
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(root);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.triggerInitialEvents(path);
                    continue;
                }
                path = WorldEdit.getInstance().getSafeOpenFile(null, schematicRoot.toFile(), schematicRoot.relativize(path).toString(), null, new String[0]).toPath();
                this.eventConsumer.accept(new FileCreatedEvent(path));
            }
        }
    }

    public void start(Consumer<DirEntryChangeEvent> eventConsumer) {
        Path schematicRoot = WorldEdit.getInstance().getSchematicsManager().getRoot();
        this.eventConsumer = eventConsumer;
        if (this.watchThread != null) {
            this.watchThread.interrupt();
            try {
                this.watchThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
            }
        }
        this.watchThread = new Thread(() -> {
            LOGGER.debug("RecursiveDirectoryWatcher::EventConsumer started");
            try {
                this.registerFolderWatcher(this.root);
                this.triggerInitialEvents(this.root);
            }
            catch (FilenameException | IOException e) {
                LOGGER.error((Object)e);
            }
            try {
                while (!Thread.interrupted()) {
                    WatchKey watchKey;
                    try {
                        watchKey = this.watchService.take();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                            LOGGER.warn("Seems like we can't keep up with updates");
                            continue;
                        }
                        Path path = (Path)event.context();
                        Path parentPath = (Path)this.watchRootMap.get((Object)watchKey);
                        path = parentPath.resolve(path);
                        if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
                            path = WorldEdit.getInstance().getSafeOpenFile(null, schematicRoot.toFile(), schematicRoot.relativize(path).toString(), null, new String[0]).toPath();
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                try {
                                    this.registerFolderWatcher(path);
                                    this.triggerInitialEvents(path);
                                }
                                catch (FilenameException | IOException e) {
                                    LOGGER.error((Object)e);
                                }
                                continue;
                            }
                            eventConsumer.accept(new FileCreatedEvent(path));
                            continue;
                        }
                        if (!kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                        if (this.watchRootMap.containsValue((Object)path)) {
                            LOGGER.debug("Watch unregistered: " + String.valueOf(path));
                            WatchKey obsoleteSubfolderWatchKey = (WatchKey)this.watchRootMap.inverse().get((Object)path);
                            obsoleteSubfolderWatchKey.cancel();
                            this.watchRootMap.remove((Object)obsoleteSubfolderWatchKey);
                            eventConsumer.accept(new DirectoryDeletedEvent(path));
                            continue;
                        }
                        eventConsumer.accept(new FileDeletedEvent(path));
                    }
                    if (watchKey.reset()) continue;
                    this.watchRootMap.remove((Object)watchKey);
                    if (!this.watchRootMap.isEmpty()) continue;
                    break;
                }
            }
            catch (FilenameException | ClosedWatchServiceException exception) {
                // empty catch block
            }
            LOGGER.debug("RecursiveDirectoryWatcher::EventConsumer exited");
        });
        this.watchThread.setName("WorldEdit-RecursiveDirectoryWatcher");
        this.watchThread.start();
    }

    @Override
    public void close() {
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        if (this.watchThread != null) {
            this.watchThread.interrupt();
            try {
                this.watchThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
            }
            this.watchThread = null;
        }
        this.eventConsumer = null;
    }

    public record DirectoryCreatedEvent(Path path) implements DirEntryChangeEvent
    {
    }

    public record FileCreatedEvent(Path path) implements DirEntryChangeEvent
    {
    }

    public record DirectoryDeletedEvent(Path path) implements DirEntryChangeEvent
    {
    }

    public record FileDeletedEvent(Path path) implements DirEntryChangeEvent
    {
    }

    public static interface DirEntryChangeEvent {
        public Path path();
    }
}

