/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.schematic.backends;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.internal.schematic.backends.SchematicsBackend;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.internal.util.RecursiveDirectoryWatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class FileWatcherSchematicsBackend
implements SchematicsBackend {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Set<Path> schematics = Sets.newConcurrentHashSet();
    private final RecursiveDirectoryWatcher directoryWatcher;

    private FileWatcherSchematicsBackend(RecursiveDirectoryWatcher directoryWatcher) {
        this.directoryWatcher = directoryWatcher;
    }

    public static FileWatcherSchematicsBackend create(Path schematicsFolder) throws IOException {
        return new FileWatcherSchematicsBackend(RecursiveDirectoryWatcher.create(schematicsFolder));
    }

    @Override
    public void init() {
        this.directoryWatcher.start(event -> {
            if (event instanceof RecursiveDirectoryWatcher.FileCreatedEvent) {
                this.schematics.add(event.path());
                LOGGER.debug("New Schematic found: " + String.valueOf(event.path()));
            } else if (event instanceof RecursiveDirectoryWatcher.FileDeletedEvent) {
                this.schematics.remove(event.path());
                LOGGER.debug("Schematic deleted: " + String.valueOf(event.path()));
            }
        });
    }

    @Override
    public void uninit() {
        this.directoryWatcher.close();
    }

    @Override
    public Set<Path> getPaths() {
        return Set.copyOf(this.schematics);
    }

    @Override
    public void update() {
    }
}

