/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.util;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.math.BlockVector3;

public final class ChangeLimitingFilter
implements RegionFunction {
    private final RegionFunction function;
    private final int limit;
    private int count = 0;

    public ChangeLimitingFilter(int limit, RegionFunction function) {
        Preconditions.checkNotNull((Object)function);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit >= 0 required");
        this.limit = limit;
        this.function = function;
    }

    @Override
    public boolean apply(BlockVector3 position) throws WorldEditException {
        if (this.count >= this.limit) {
            throw new MaxChangedBlocksException(this.limit);
        }
        ++this.count;
        return this.function.apply(position);
    }
}

