/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.generator.TreeGenerator;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.generation.TreeType;
import javax.annotation.Nullable;

public class TreePlanter
implements BlockTool {
    private final TreeType treeType;

    public TreePlanter(TreeType treeType) {
        this.treeType = treeType;
    }

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked, @Nullable Direction face) {
        try (EditSession editSession = BlockTool.createEditSession(player, session, clicked);){
            try {
                boolean successful = new TreeGenerator(editSession, this.treeType).apply(clicked.toVector().toBlockPoint());
                if (!successful) {
                    player.printError(TranslatableComponent.of("worldedit.tool.tree.obstructed"));
                }
            }
            catch (MaxChangedBlocksException e) {
                player.printError(TranslatableComponent.of("worldedit.tool.max-block-changes"));
            }
            catch (WorldEditException worldEditException) {
                session.remember(editSession);
            }
            finally {
                session.remember(editSession);
            }
        }
        return true;
    }
}

