/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.velocity.wrapper.WrapperVelocity;

public class SkinApplierVelocity
implements SkinApplierAccess<Player> {
    private final WrapperVelocity wrapper;
    private final EventBusImpl eventBus;

    @Override
    public void applySkin(Player player, SkinProperty property) {
        SkinApplyEventImpl applyEvent = new SkinApplyEventImpl(player, property);
        this.eventBus.callEvent(applyEvent);
        if (applyEvent.isCancelled()) {
            return;
        }
        SkinProperty appliedProperty = applyEvent.getProperty();
        player.setGameProfileProperties(this.updatePropertiesSkin(player.getGameProfileProperties(), appliedProperty));
        this.wrapper.player(player).sendToMessageChannel(new SRServerPluginMessage(new SRServerPluginMessage.SkinUpdateChannelPayload(property)));
    }

    public GameProfile updateProfileSkin(GameProfile profile, SkinProperty property) {
        return new GameProfile(profile.getId(), profile.getName(), this.updatePropertiesSkin(profile.getProperties(), property));
    }

    private List<GameProfile.Property> updatePropertiesSkin(List<GameProfile.Property> original, SkinProperty property) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(original);
        properties.removeIf(property1 -> property1.getName().equals("textures"));
        properties.add(new GameProfile.Property("textures", property.getValue(), property.getSignature()));
        return properties;
    }

    public Optional<SkinProperty> getSkinProperty(Player player) {
        return player.getGameProfileProperties().stream().map(property -> SkinProperty.tryParse(property.getName(), property.getValue(), property.getSignature())).flatMap(J_U_Optional::stream).findFirst();
    }

    @Inject
    @Generated
    public SkinApplierVelocity(WrapperVelocity wrapper, EventBusImpl eventBus) {
        this.wrapper = wrapper;
        this.eventBus = eventBus;
    }
}

