/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Provider;

public class ProviderSelector<P> {
    private P provider;

    public static <P> ProviderSelector<P> selector() {
        return new ProviderSelector<P>();
    }

    public ProviderSelector<P> add(BooleanSupplier availableCheck, Provider<P> provider) {
        if (this.provider != null) {
            return this;
        }
        if (availableCheck.getAsBoolean()) {
            this.provider = provider.get();
        }
        return this;
    }

    public ProviderSelector<P> add(BooleanSupplier availableCheck, P provider) {
        return this.add(availableCheck, (P)((Provider<Object>)() -> provider));
    }

    public ProviderSelector<P> addDefault(Provider<P> provider) {
        return this.add(() -> true, (P)provider);
    }

    public ProviderSelector<P> addDefault(P provider) {
        return this.addDefault((P)((Provider<Object>)() -> provider));
    }

    public P get() {
        return Objects.requireNonNull(this.provider, "No provider available");
    }

    @Generated
    private ProviderSelector() {
    }
}

