/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.update.UpdateCause;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.update.UpdateDownloader;

public class UpdateCheckExecutor {
    private final SRPlatformAdapter adapter;
    private final SettingsManager settings;

    public void checkUpdate(UpdateCause cause, UpdateCheckerGitHub updateChecker, UpdateDownloader downloader, boolean isSync) {
        if (this.settings.getProperty(AdvancedConfig.NO_CONNECTIONS).booleanValue()) {
            updateChecker.printUpToDate(UpdateCause.NO_NETWORK);
            return;
        }
        Runnable check = () -> updateChecker.checkForUpdate(cause, downloader);
        if (isSync) {
            this.adapter.runAsync(check);
        } else {
            check.run();
        }
    }

    @Inject
    @Generated
    public UpdateCheckExecutor(SRPlatformAdapter adapter, SettingsManager settings) {
        this.adapter = adapter;
        this.settings = settings;
    }
}

