/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.permissions;

import java.util.function.Function;
import lombok.Generated;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.utils.Tristate;

public class Permission {
    private final String permissionString;

    public boolean checkPermission(Function<String, Tristate> predicate) {
        Tristate tristate = this.internalCheckPermission(predicate);
        if (tristate != Tristate.UNDEFINED) {
            return tristate.asBoolean();
        }
        for (PermissionGroup permissionGroup : PermissionGroup.getGrantedBy(this)) {
            if (permissionGroup == PermissionGroup.DEFAULT_GROUP) {
                return true;
            }
            Tristate groupTristate = permissionGroup.getBasePermission().internalCheckPermission(predicate);
            if (groupTristate != Tristate.UNDEFINED) {
                return groupTristate.asBoolean();
            }
            Tristate wildcardTristate = permissionGroup.getWildcard().internalCheckPermission(predicate);
            if (wildcardTristate == Tristate.UNDEFINED) continue;
            return wildcardTristate.asBoolean();
        }
        return false;
    }

    public Tristate internalCheckPermission(Function<String, Tristate> predicate) {
        return predicate.apply(this.permissionString);
    }

    public boolean isInDefaultGroup() {
        return PermissionGroup.getGrantedBy(this).contains((Object)PermissionGroup.DEFAULT_GROUP);
    }

    @Generated
    public String getPermissionString() {
        return this.permissionString;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$permissionString = this.getPermissionString();
        String other$permissionString = other.getPermissionString();
        return !(this$permissionString == null ? other$permissionString != null : !this$permissionString.equals(other$permissionString));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Permission;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $permissionString = this.getPermissionString();
        result = result * 59 + ($permissionString == null ? 43 : $permissionString.hashCode());
        return result;
    }

    @Generated
    private Permission(String permissionString) {
        this.permissionString = permissionString;
    }

    @NotNull
    @Generated
    public static Permission of(String permissionString) {
        return new Permission(permissionString);
    }
}

