/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j19.stub.java_base.J_U_Locale;
import net.skinsrestorer.shared.subjects.messages.Message;

public class LocaleManager {
    public static final Locale BASE_LOCALE = Locale.ENGLISH;
    private final Map<Message, Map<Locale, String>> messages = new EnumMap<Message, Map<Locale, String>>(Message.class);

    public void addMessage(Message key, Locale locale, String message) {
        this.messages.computeIfAbsent(key, k -> new HashMap()).put(locale, message);
    }

    public void verifyValid() {
        for (Message message : Message.values()) {
            if (this.messages.containsKey((Object)message)) continue;
            throw new IllegalStateException(J_L_String.formatted("Message %s not found", message.name()));
        }
        for (Message message : Message.values()) {
            Map<Locale, String> localeMap = this.messages.get((Object)message);
            if (localeMap.containsKey(BASE_LOCALE)) continue;
            throw new IllegalStateException(J_L_String.formatted("Message %s does not have a default translation", message.name()));
        }
    }

    public String getMessage(Locale locale, Message key) {
        Map<Locale, String> localeMap = this.messages.get((Object)key);
        return Optional.ofNullable(localeMap.get(J_U_Locale.of(locale.getLanguage(), locale.getCountry()))).orElseGet(() -> Optional.ofNullable((String)localeMap.get(J_U_Locale.of(locale.getLanguage()))).orElse((String)localeMap.get(BASE_LOCALE)));
    }

    @Inject
    @Generated
    public LocaleManager() {
    }
}

