/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.ijannotations.Language;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.pool.Pool;
import net.skinsrestorer.shadow.mariadb.pool.Pools;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;

public class MySQLProvider {
    private final SRLogger logger;
    private final SettingsManager settings;
    private Pool pool;

    public void initPool() throws SQLException {
        String host = this.settings.getProperty(DatabaseConfig.MYSQL_HOST);
        String username = this.settings.getProperty(DatabaseConfig.MYSQL_USERNAME);
        String password = this.settings.getProperty(DatabaseConfig.MYSQL_PASSWORD);
        String database = this.settings.getProperty(DatabaseConfig.MYSQL_DATABASE);
        int port = this.settings.getProperty(DatabaseConfig.MYSQL_PORT);
        int maxPoolSize = this.settings.getProperty(DatabaseConfig.MYSQL_MAX_POOL_SIZE);
        String options = this.settings.getProperty(DatabaseConfig.MYSQL_CONNECTION_OPTIONS);
        Configuration configuration = Configuration.parse(J_L_String.formatted("jdbc:mysql://%s:%d/%s?permitMysqlScheme&maxPoolSize=%d&%s", host, port, database, maxPoolSize, options));
        this.pool = Pools.retrievePool(configuration.clone(username, password));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int update(@Language(value="sql") String query, Object ... vars) {
        try (Connection connection = this.pool.getPoolConnection().getConnection();){
            int n;
            block16: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    this.fillPreparedStatement(ps, vars);
                    n = ps.executeUpdate();
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1060) {
                return -1;
            }
            this.logger.warning(J_L_String.formatted("MySQL error: %s", e.getMessage()), e);
            if (SRPlugin.isUnitTest()) {
                throw new AssertionError((Object)e);
            }
            return -1;
        }
    }

    public ResultSet query(@Language(value="sql") String query, Object ... vars) throws SQLException {
        try (Connection connection = this.pool.getPoolConnection().getConnection();){
            ResultSet resultSet;
            block12: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    this.fillPreparedStatement(ps, vars);
                    resultSet = ps.executeQuery();
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return resultSet;
        }
    }

    private void fillPreparedStatement(PreparedStatement ps, Object ... vars) throws SQLException {
        int i = 0;
        for (Object obj : vars) {
            ++i;
            try {
                ps.setObject(i, obj);
            }
            catch (SQLException e) {
                throw new SQLException(J_L_String.formatted("Error while setting prepared statement variable #%d (%s): %s", i, obj, e.getMessage()));
            }
        }
    }

    @Inject
    @Generated
    public MySQLProvider(SRLogger logger, SettingsManager settings) {
        this.logger = logger;
        this.settings = settings;
    }
}

