/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.GsonBuilder;
import net.skinsrestorer.shadow.gson.JsonDeserializationContext;
import net.skinsrestorer.shadow.gson.JsonDeserializer;
import net.skinsrestorer.shadow.gson.JsonElement;
import net.skinsrestorer.shadow.gson.JsonParseException;
import net.skinsrestorer.shadow.gson.JsonPrimitive;
import net.skinsrestorer.shadow.gson.JsonSerializationContext;
import net.skinsrestorer.shadow.gson.JsonSerializer;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.gui.GUIUtils;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.adapter.file.model.cache.MojangCacheFile;
import net.skinsrestorer.shared.storage.adapter.file.model.cooldown.CooldownFile;
import net.skinsrestorer.shared.storage.adapter.file.model.player.LegacyPlayerFile;
import net.skinsrestorer.shared.storage.adapter.file.model.player.PlayerFile;
import net.skinsrestorer.shared.storage.adapter.file.model.skin.CustomSkinFile;
import net.skinsrestorer.shared.storage.adapter.file.model.skin.LegacySkinFile;
import net.skinsrestorer.shared.storage.adapter.file.model.skin.PlayerSkinFile;
import net.skinsrestorer.shared.storage.adapter.file.model.skin.URLIndexFile;
import net.skinsrestorer.shared.storage.adapter.file.model.skin.URLSkinFile;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.player.LegacyPlayerData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.shared.utils.UUIDUtils;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={ComponentStringSerializer.class, GUIFileData.class})
public class FileAdapter
implements StorageAdapter {
    private final Path skinsFolder;
    private final Path playersFolder;
    private final Path cooldownsFolder;
    private final Path cacheFolder;
    private final Path legacyFolder;
    private final SettingsManager settings;
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)ComponentString.class), new ComponentStringSerializer()).create();
    private final SRLogger logger;

    @Inject
    public FileAdapter(SRPlugin plugin, SettingsManager settings, SRLogger logger) {
        Path dataFolder = plugin.getDataFolder();
        this.skinsFolder = dataFolder.resolve("skins");
        this.playersFolder = dataFolder.resolve("players");
        this.cooldownsFolder = dataFolder.resolve("cooldowns");
        this.cacheFolder = dataFolder.resolve("cache");
        this.legacyFolder = dataFolder.resolve("legacy");
        this.settings = settings;
        this.logger = logger;
        try {
            this.migrate(dataFolder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.init();
    }

    @Override
    public void init() {
        SRHelpers.createDirectoriesSafe(this.skinsFolder);
        SRHelpers.createDirectoriesSafe(this.playersFolder);
        SRHelpers.createDirectoriesSafe(this.cooldownsFolder);
        SRHelpers.createDirectoriesSafe(this.cacheFolder);
    }

    private void migrate(Path dataFolder) throws IOException {
        SRHelpers.renameFile(dataFolder, "Skins", "skins");
        SRHelpers.renameFile(dataFolder, "Players", "players");
        this.migrateSkins();
        this.migratePlayers();
    }

    private void migratePlayers() {
        if (!Files.exists(this.playersFolder, new LinkOption[0])) {
            return;
        }
        Path legacyPlayersFolder = this.legacyFolder.resolve("players");
        boolean generatedFolder = false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.playersFolder, "*.player");){
            for (Path path : stream) {
                String fileName = path.getFileName().toString();
                String playerName = fileName.substring(0, fileName.length() - ".player".length());
                if (UUIDUtils.tryParseUniqueId(playerName).isPresent()) {
                    return;
                }
                if (!generatedFolder) {
                    generatedFolder = true;
                    SRHelpers.createDirectoriesSafe(legacyPlayersFolder);
                    this.logger.info("Migrating legacy player files to new format...");
                }
                try {
                    Path legacyPlayerFile = this.resolveLegacyPlayerFile(playerName);
                    if (Files.exists(legacyPlayerFile, new LinkOption[0])) continue;
                    String skinName = J_N_F_Files.readString(path);
                    LegacyPlayerData legacyPlayerData = LegacyPlayerData.of(playerName, skinName);
                    SRHelpers.writeIfNeeded(legacyPlayerFile, this.gson.toJson(LegacyPlayerFile.fromLegacyPlayerData(legacyPlayerData)));
                    Files.deleteIfExists(path);
                }
                catch (Exception e) {
                    this.logger.warning(FileAdapter.jvmdowngrader$concat$migratePlayers$1(String.valueOf(path.getFileName())), e);
                }
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to migrate legacy player files", e);
        }
        if (generatedFolder) {
            this.logger.info("Player files migration complete!");
        }
    }

    private void migrateSkins() {
        if (!Files.exists(this.skinsFolder, new LinkOption[0])) {
            return;
        }
        Path legacySkinsFolder = this.legacyFolder.resolve("skins");
        boolean generatedFolder = false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.skinsFolder, "*.skin");){
            for (Path path : stream) {
                if (!generatedFolder) {
                    generatedFolder = true;
                    SRHelpers.createDirectoriesSafe(legacySkinsFolder);
                    this.logger.info("Migrating legacy skin files to new format...");
                }
                try {
                    String fileName = path.getFileName().toString();
                    String skinName = fileName.substring(0, fileName.length() - ".skin".length());
                    Path legacySkinFile = this.resolveLegacySkinFile(skinName);
                    if (Files.exists(legacySkinFile, new LinkOption[0])) continue;
                    String[] lines = J_N_F_Files.readString(path).split("\n");
                    String skinValue = lines[0].trim();
                    String skinSignature = lines[1].trim();
                    SkinProperty skinProperty = SkinProperty.of(skinValue, skinSignature);
                    if (lines.length == 2 || this.isLegacyCustomSkinTimestamp(Long.parseLong(lines[2].trim()))) {
                        this.setCustomSkinData(skinName, CustomSkinData.of(skinName, null, skinProperty));
                    } else {
                        LegacySkinData legacySkinData = LegacySkinData.of(skinName, skinProperty);
                        SRHelpers.writeIfNeeded(legacySkinFile, this.gson.toJson(LegacySkinFile.fromLegacySkinData(legacySkinData)));
                    }
                    Files.deleteIfExists(path);
                }
                catch (Exception e) {
                    this.logger.warning(FileAdapter.jvmdowngrader$concat$migrateSkins$1(String.valueOf(path.getFileName())), e);
                }
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to migrate legacy skin files", e);
        }
        if (generatedFolder) {
            this.logger.info("Skin files migration complete!");
        }
    }

    @Override
    public Optional<PlayerData> getPlayerData(UUID uuid) throws StorageAdapter.StorageException {
        Path playerFile = this.resolvePlayerFile(uuid);
        if (!Files.exists(playerFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(playerFile);
            PlayerFile file = this.gson.fromJson(json, PlayerFile.class);
            return Optional.of(file.toPlayerData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void setPlayerData(UUID uuid, PlayerData data) {
        Path playerFile = this.resolvePlayerFile(uuid);
        try {
            PlayerFile file = PlayerFile.fromPlayerData(data);
            SRHelpers.writeIfNeeded(playerFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setPlayerData$1(String.valueOf(uuid)), e);
        }
    }

    @Override
    public Optional<PlayerSkinData> getPlayerSkinData(UUID uuid) throws StorageAdapter.StorageException {
        Path skinFile = this.resolvePlayerSkinFile(uuid);
        if (!Files.exists(skinFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(skinFile);
            PlayerSkinFile file = this.gson.fromJson(json, PlayerSkinFile.class);
            return Optional.of(file.toPlayerSkinData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removePlayerSkinData(UUID uuid) {
        Path skinFile = this.resolvePlayerSkinFile(uuid);
        try {
            Files.deleteIfExists(skinFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removePlayerSkinData$1(String.valueOf(uuid)), e);
        }
    }

    @Override
    public void setPlayerSkinData(UUID uuid, PlayerSkinData skinData) {
        Path skinFile = this.resolvePlayerSkinFile(uuid);
        try {
            PlayerSkinFile file = PlayerSkinFile.fromPlayerSkinData(skinData);
            SRHelpers.writeIfNeeded(skinFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setPlayerSkinData$1(String.valueOf(uuid)), e);
        }
    }

    @Override
    public Optional<URLSkinData> getURLSkinData(String url, SkinVariant skinVariant) throws StorageAdapter.StorageException {
        Path skinFile = this.resolveURLSkinFile(url, skinVariant);
        if (!Files.exists(skinFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(skinFile);
            URLSkinFile file = this.gson.fromJson(json, URLSkinFile.class);
            return Optional.of(file.toURLSkinData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinData(String url, SkinVariant skinVariant) {
        Path skinFile = this.resolveURLSkinFile(url, skinVariant);
        try {
            Files.deleteIfExists(skinFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeURLSkinData$1(url), e);
        }
    }

    @Override
    public void setURLSkinData(String url, URLSkinData skinData) {
        Path skinFile = this.resolveURLSkinFile(url, skinData.getSkinVariant());
        try {
            URLSkinFile file = URLSkinFile.fromURLSkinData(skinData);
            SRHelpers.writeIfNeeded(skinFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setURLSkinData$1(url), e);
        }
    }

    @Override
    public Optional<URLIndexData> getURLSkinIndex(String url) throws StorageAdapter.StorageException {
        Path skinFile = this.resolveURLSkinIndexFile(url);
        if (!Files.exists(skinFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(skinFile);
            URLIndexFile file = this.gson.fromJson(json, URLIndexFile.class);
            return Optional.of(file.toURLIndexData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinIndex(String url) {
        Path skinFile = this.resolveURLSkinIndexFile(url);
        try {
            Files.deleteIfExists(skinFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeURLSkinIndex$1(url), e);
        }
    }

    @Override
    public void setURLSkinIndex(String url, URLIndexData skinData) {
        Path skinFile = this.resolveURLSkinIndexFile(url);
        try {
            URLIndexFile file = URLIndexFile.fromURLIndexData(skinData);
            SRHelpers.writeIfNeeded(skinFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setURLSkinIndex$1(url), e);
        }
    }

    @Override
    public Optional<CustomSkinData> getCustomSkinData(String skinName) throws StorageAdapter.StorageException {
        Path skinFile = this.resolveCustomSkinFile(skinName = CustomSkinData.sanitizeCustomSkinName(skinName));
        if (!Files.exists(skinFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(skinFile);
            CustomSkinFile file = this.gson.fromJson(json, CustomSkinFile.class);
            return Optional.of(file.toCustomSkinData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeCustomSkinData(String skinName) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        Path skinFile = this.resolveCustomSkinFile(skinName);
        try {
            Files.deleteIfExists(skinFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeCustomSkinData$1(skinName), e);
        }
    }

    @Override
    public void setCustomSkinData(String skinName, CustomSkinData skinData) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        Path skinFile = this.resolveCustomSkinFile(skinName);
        try {
            CustomSkinFile file = CustomSkinFile.fromCustomSkinData(skinData);
            SRHelpers.writeIfNeeded(skinFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setCustomSkinData$1(skinName), e);
        }
    }

    @Override
    public Optional<LegacySkinData> getLegacySkinData(String skinName) throws StorageAdapter.StorageException {
        Path skinFile = this.resolveLegacySkinFile(skinName = this.sanitizeLegacySkinName(skinName));
        if (!Files.exists(skinFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(skinFile);
            LegacySkinFile file = this.gson.fromJson(json, LegacySkinFile.class);
            return Optional.of(file.toLegacySkinData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacySkinData(String skinName) {
        skinName = this.sanitizeLegacySkinName(skinName);
        Path skinFile = this.resolveLegacySkinFile(skinName);
        try {
            Files.deleteIfExists(skinFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeLegacySkinData$1(skinName), e);
        }
    }

    @Override
    public Optional<LegacyPlayerData> getLegacyPlayerData(String playerName) throws StorageAdapter.StorageException {
        Path legacyFile = this.resolveLegacyPlayerFile(playerName = this.sanitizeLegacyPlayerName(playerName));
        if (!Files.exists(legacyFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(legacyFile);
            LegacyPlayerFile file = this.gson.fromJson(json, LegacyPlayerFile.class);
            return Optional.of(file.toLegacyPlayerData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacyPlayerData(String playerName) {
        playerName = this.sanitizeLegacyPlayerName(playerName);
        Path legacyFile = this.resolveLegacyPlayerFile(playerName);
        try {
            Files.deleteIfExists(legacyFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeLegacyPlayerData$1(playerName), e);
        }
    }

    @Override
    public int getTotalCustomSkins() {
        return this.getCustomGUISkinFiles(0, Integer.MAX_VALUE).size();
    }

    @Override
    public List<GUIUtils.GUIRawSkinEntry> getCustomGUISkins(int offset, int limit) {
        ArrayList<GUIUtils.GUIRawSkinEntry> list = new ArrayList<GUIUtils.GUIRawSkinEntry>();
        List<GUIFileData> files = this.getCustomGUISkinFiles(offset, limit);
        for (GUIFileData data : files) {
            String fileName = data.fileName();
            try {
                CustomSkinData customSkinData = J_U_Optional.orElseThrow(this.getCustomSkinData(fileName));
                list.add(new GUIUtils.GUIRawSkinEntry(SkinIdentifier.ofCustom(fileName), customSkinData.getDisplayName() == null ? ComponentHelper.convertPlainToJson(fileName) : customSkinData.getDisplayName(), PropertyUtils.getSkinTextureHash(customSkinData.getProperty()), J_U_List.of()));
            }
            catch (StorageAdapter.StorageException e) {
                this.logger.warning(FileAdapter.jvmdowngrader$concat$getCustomGUISkins$1(fileName), e);
            }
        }
        return list;
    }

    private List<GUIFileData> getCustomGUISkinFiles(int offset, int limit) {
        boolean onlyList = this.settings.getProperty(GUIConfig.CUSTOM_GUI_ONLY_LIST);
        Set onlyListSkins = this.settings.getProperty(GUIConfig.CUSTOM_GUI_LIST).stream().map(CustomSkinData::sanitizeCustomSkinName).collect(Collectors.toSet());
        ArrayList<GUIFileData> files = new ArrayList<GUIFileData>();
        try (Stream<Path> stream = Files.walk(this.skinsFolder, 1, new FileVisitOption[0]);){
            int skinIndex = 0;
            for (Path path : stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparing(Path::getFileName))::iterator) {
                String fileName = path.getFileName().toString();
                int lastDotIndex = fileName.lastIndexOf(".");
                if (lastDotIndex == -1) continue;
                String extension = fileName.substring(lastDotIndex + 1);
                String name = fileName.substring(0, lastDotIndex);
                if (name.startsWith("sr-recommendation-") || !extension.equals("customskin") || onlyList && !onlyListSkins.contains(name.toLowerCase(Locale.ROOT))) continue;
                if (skinIndex < offset) {
                    ++skinIndex;
                    continue;
                }
                files.add(new GUIFileData(name, path));
                if (skinIndex++ < offset + limit) continue;
                break;
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to load GUI files", e);
        }
        return files;
    }

    @Override
    public int getTotalPlayerSkins() {
        return this.getPlayerGUISkinFiles(0, Integer.MAX_VALUE).size();
    }

    @Override
    public List<GUIUtils.GUIRawSkinEntry> getPlayerGUISkins(int offset, int limit) {
        ArrayList<GUIUtils.GUIRawSkinEntry> list = new ArrayList<GUIUtils.GUIRawSkinEntry>();
        List<GUIFileData> files = this.getPlayerGUISkinFiles(offset, limit);
        for (GUIFileData data : files) {
            String fileName = data.fileName();
            try {
                PlayerSkinData playerSkinData = J_U_Optional.orElseThrow(this.getPlayerSkinData(UUID.fromString(fileName)));
                list.add(new GUIUtils.GUIRawSkinEntry(SkinIdentifier.ofPlayer(UUID.fromString(fileName)), ComponentHelper.convertPlainToJson(playerSkinData.getLastKnownName()), PropertyUtils.getSkinTextureHash(playerSkinData.getProperty()), J_U_List.of()));
            }
            catch (StorageAdapter.StorageException e) {
                this.logger.warning(FileAdapter.jvmdowngrader$concat$getCustomGUISkins$1(fileName), e);
            }
        }
        return list;
    }

    private List<GUIFileData> getPlayerGUISkinFiles(int offset, int limit) {
        boolean onlyList = this.settings.getProperty(GUIConfig.PLAYERS_GUI_ONLY_LIST);
        Set onlyListSkins = this.settings.getProperty(GUIConfig.PLAYERS_GUI_LIST).stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        ArrayList<GUIFileData> files = new ArrayList<GUIFileData>();
        try (Stream<Path> stream = Files.walk(this.skinsFolder, 1, new FileVisitOption[0]);){
            int skinIndex = 0;
            for (Path path : stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparing(Path::getFileName))::iterator) {
                String fileName = path.getFileName().toString();
                int lastDotIndex = fileName.lastIndexOf(".");
                if (lastDotIndex == -1) continue;
                String extension = fileName.substring(lastDotIndex + 1);
                String name = fileName.substring(0, lastDotIndex);
                if (!extension.equals("playerskin") || onlyList && !onlyListSkins.contains(name.toLowerCase(Locale.ROOT))) continue;
                if (skinIndex < offset) {
                    ++skinIndex;
                    continue;
                }
                files.add(new GUIFileData(name, path));
                if (skinIndex++ < offset + limit) continue;
                break;
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to load GUI files", e);
        }
        return files;
    }

    @Override
    public void purgeStoredOldSkins(long targetPurgeTimestamp) throws StorageAdapter.StorageException {
        ArrayList files = new ArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.skinsFolder, "*.playerskin");){
            stream.forEach(files::add);
        }
        catch (IOException e) {
            throw new StorageAdapter.StorageException(e);
        }
        for (Path file : files) {
            try {
                String json = J_N_F_Files.readString(file);
                PlayerSkinFile skinFile = this.gson.fromJson(json, PlayerSkinFile.class);
                if (skinFile.getTimestamp() == 0L || skinFile.getTimestamp() >= targetPurgeTimestamp) continue;
                Files.deleteIfExists(file);
            }
            catch (Exception e) {
                throw new StorageAdapter.StorageException(e);
            }
        }
    }

    @Override
    public Optional<MojangCacheData> getCachedUUID(String playerName) throws StorageAdapter.StorageException {
        Path cacheFile = this.resolveCacheFile(playerName);
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String json = J_N_F_Files.readString(cacheFile);
            MojangCacheFile file = this.gson.fromJson(json, MojangCacheFile.class);
            return Optional.of(file.toCacheData());
        }
        catch (Exception e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void setCachedUUID(String playerName, MojangCacheData mojangCacheData) {
        Path cacheFile = this.resolveCacheFile(playerName);
        try {
            MojangCacheFile file = MojangCacheFile.fromMojangCacheData(mojangCacheData);
            SRHelpers.writeIfNeeded(cacheFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setCachedUUID$1(playerName), e);
        }
    }

    @Override
    public List<UUID> getAllCooldownProfiles() throws StorageAdapter.StorageException {
        ArrayList<UUID> arrayList;
        block9: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.cooldownsFolder);
            try {
                ArrayList<UUID> list = new ArrayList<UUID>();
                for (Path path : stream) {
                    String fileName = path.getFileName().toString();
                    String[] parts = fileName.split("_");
                    if (parts.length != 2) continue;
                    UUID uuid = UUID.fromString(parts[0]);
                    list.add(uuid);
                }
                arrayList = list;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageAdapter.StorageException(e);
                }
            }
            stream.close();
        }
        return arrayList;
    }

    @Override
    public List<StorageAdapter.StorageCooldown> getCooldowns(UUID owner) throws StorageAdapter.StorageException {
        ArrayList<StorageAdapter.StorageCooldown> arrayList;
        block11: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.cooldownsFolder);
            try {
                ArrayList<StorageAdapter.StorageCooldown> list = new ArrayList<StorageAdapter.StorageCooldown>();
                for (Path path : stream) {
                    UUID uuid;
                    String fileName = path.getFileName().toString();
                    String[] parts = fileName.split("_");
                    if (parts.length != 2 || (uuid = UUIDUtils.parseUniqueIdNullable(parts[0])) == null || !uuid.equals(owner)) continue;
                    try {
                        String json = J_N_F_Files.readString(path);
                        CooldownFile file = this.gson.fromJson(json, CooldownFile.class);
                        list.add(file.toCooldownData());
                    }
                    catch (Exception e) {
                        this.logger.debug(FileAdapter.jvmdowngrader$concat$getCooldowns$1(String.valueOf(owner)), e);
                    }
                }
                arrayList = list;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageAdapter.StorageException(e);
                }
            }
            stream.close();
        }
        return arrayList;
    }

    @Override
    public void setCooldown(UUID owner, String groupName, Instant creationTime, Duration duration) {
        Path cooldownFile = this.resolveCooldownFile(owner, groupName);
        try {
            CooldownFile file = CooldownFile.fromCooldownData(new StorageAdapter.StorageCooldown(owner, groupName, creationTime, duration));
            SRHelpers.writeIfNeeded(cooldownFile, this.gson.toJson(file));
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$setCooldown$1(String.valueOf(owner)), e);
        }
    }

    @Override
    public void removeCooldown(UUID owner, String groupName) {
        Path cooldownFile = this.resolveCooldownFile(owner, groupName);
        try {
            Files.deleteIfExists(cooldownFile);
        }
        catch (IOException e) {
            this.logger.warning(FileAdapter.jvmdowngrader$concat$removeCooldown$1(String.valueOf(owner)), e);
        }
    }

    private Path resolveCustomSkinFile(String skinName) {
        return this.skinsFolder.resolve(FileAdapter.jvmdowngrader$concat$resolveCustomSkinFile$1(skinName));
    }

    private Path resolveLegacySkinFile(String skinName) {
        return this.legacyFolder.resolve("skins").resolve(FileAdapter.jvmdowngrader$concat$resolveLegacySkinFile$1(skinName));
    }

    private Path resolveURLSkinFile(String url, SkinVariant skinVariant) {
        return this.skinsFolder.resolve(FileAdapter.jvmdowngrader$concat$resolveURLSkinFile$1(SRHelpers.hashSha256ToHex(url), skinVariant.name()));
    }

    private Path resolveURLSkinIndexFile(String url) {
        return this.skinsFolder.resolve(FileAdapter.jvmdowngrader$concat$resolveURLSkinIndexFile$1(SRHelpers.hashSha256ToHex(url)));
    }

    private Path resolvePlayerSkinFile(UUID uuid) {
        return this.skinsFolder.resolve(FileAdapter.jvmdowngrader$concat$resolvePlayerSkinFile$1(String.valueOf(uuid)));
    }

    private Path resolvePlayerFile(UUID uuid) {
        return this.playersFolder.resolve(FileAdapter.jvmdowngrader$concat$resolvePlayerFile$1(String.valueOf(uuid)));
    }

    private Path resolveLegacyPlayerFile(String name) {
        return this.legacyFolder.resolve("players").resolve(FileAdapter.jvmdowngrader$concat$resolveLegacyPlayerFile$1(name));
    }

    private Path resolveCooldownFile(UUID uuid, String groupName) {
        return this.cooldownsFolder.resolve(FileAdapter.jvmdowngrader$concat$resolveCooldownFile$1(String.valueOf(uuid), groupName));
    }

    private Path resolveCacheFile(String name) {
        return this.cacheFolder.resolve(FileAdapter.jvmdowngrader$concat$resolveCacheFile$1(name));
    }

    private String sanitizeLegacyPlayerName(String playerName) {
        return playerName.toLowerCase();
    }

    private String sanitizeLegacySkinName(String skinName) {
        return skinName.toLowerCase();
    }

    private static String jvmdowngrader$concat$migratePlayers$1(String string) {
        return "Failed to migrate legacy player file: " + string;
    }

    private static String jvmdowngrader$concat$migrateSkins$1(String string) {
        return "Failed to migrate legacy skin file: " + string;
    }

    private static String jvmdowngrader$concat$setPlayerData$1(String string) {
        return "Failed to save player data for " + string;
    }

    private static String jvmdowngrader$concat$removePlayerSkinData$1(String string) {
        return "Failed to remove player skin data for " + string;
    }

    private static String jvmdowngrader$concat$setPlayerSkinData$1(String string) {
        return "Failed to save player skin data for " + string;
    }

    private static String jvmdowngrader$concat$removeURLSkinData$1(String string) {
        return "Failed to remove URL skin data for " + string;
    }

    private static String jvmdowngrader$concat$setURLSkinData$1(String string) {
        return "Failed to save URL skin data for " + string;
    }

    private static String jvmdowngrader$concat$removeURLSkinIndex$1(String string) {
        return "Failed to remove URL skin index for " + string;
    }

    private static String jvmdowngrader$concat$setURLSkinIndex$1(String string) {
        return "Failed to save URL skin index for " + string;
    }

    private static String jvmdowngrader$concat$removeCustomSkinData$1(String string) {
        return "Failed to remove custom skin data for " + string;
    }

    private static String jvmdowngrader$concat$setCustomSkinData$1(String string) {
        return "Failed to save custom skin data for " + string;
    }

    private static String jvmdowngrader$concat$removeLegacySkinData$1(String string) {
        return "Failed to remove legacy skin data for " + string;
    }

    private static String jvmdowngrader$concat$removeLegacyPlayerData$1(String string) {
        return "Failed to remove legacy player data for " + string;
    }

    private static String jvmdowngrader$concat$getCustomGUISkins$1(String string) {
        return "Failed to load skin data for " + string;
    }

    private static String jvmdowngrader$concat$setCachedUUID$1(String string) {
        return "Failed to save cached UUID for " + string;
    }

    private static String jvmdowngrader$concat$getCooldowns$1(String string) {
        return "Failed to load cooldown data for " + string;
    }

    private static String jvmdowngrader$concat$setCooldown$1(String string) {
        return "Failed to save cooldown data for " + string;
    }

    private static String jvmdowngrader$concat$removeCooldown$1(String string) {
        return "Failed to remove cooldown data for " + string;
    }

    private static String jvmdowngrader$concat$resolveCustomSkinFile$1(String string) {
        return string + ".customskin";
    }

    private static String jvmdowngrader$concat$resolveLegacySkinFile$1(String string) {
        return string + ".legacyskin";
    }

    private static String jvmdowngrader$concat$resolveURLSkinFile$1(String string, String string2) {
        return string + "_" + string2 + ".urlskin";
    }

    private static String jvmdowngrader$concat$resolveURLSkinIndexFile$1(String string) {
        return string + ".urlindex";
    }

    private static String jvmdowngrader$concat$resolvePlayerSkinFile$1(String string) {
        return string + ".playerskin";
    }

    private static String jvmdowngrader$concat$resolvePlayerFile$1(String string) {
        return string + ".player";
    }

    private static String jvmdowngrader$concat$resolveLegacyPlayerFile$1(String string) {
        return string + ".legacyplayer";
    }

    private static String jvmdowngrader$concat$resolveCooldownFile$1(String string, String string2) {
        return string + "_" + string2 + ".cooldown";
    }

    private static String jvmdowngrader$concat$resolveCacheFile$1(String string) {
        return string + ".mojangcache";
    }

    @NestHost(value=FileAdapter.class)
    private static final class ComponentStringSerializer
    extends J_L_Record
    implements JsonSerializer<ComponentString>,
    JsonDeserializer<ComponentString> {
        ComponentStringSerializer() {
        }

        @Override
        public ComponentString deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ComponentString(json.getAsString());
        }

        @Override
        public JsonElement serialize(ComponentString src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.jsonString());
        }

        @Override
        public final String toString() {
            return ComponentStringSerializer.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ComponentStringSerializer.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ComponentStringSerializer.jvmdowngrader$equals$equals(this, o);
        }

        private static String jvmdowngrader$toString$toString(ComponentStringSerializer componentStringSerializer) {
            ComponentStringSerializer componentStringSerializer2 = componentStringSerializer;
            return "FileAdapter$ComponentStringSerializer[" + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ComponentStringSerializer componentStringSerializer) {
            Object[] objectArray = new Object[]{};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ComponentStringSerializer componentStringSerializer, Object object) {
            if (componentStringSerializer == object) {
                return true;
            }
            if (object != null && object instanceof ComponentStringSerializer) {
                ComponentStringSerializer componentStringSerializer2 = (ComponentStringSerializer)object;
                return true;
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="fileName", type=String.class), @RecordComponents.Value(name="path", type=Path.class)})
    @NestHost(value=FileAdapter.class)
    private static final class GUIFileData
    extends J_L_Record {
        private final String fileName;
        private final Path path;

        GUIFileData(String fileName, Path path) {
            this.fileName = fileName;
            this.path = path;
        }

        @Override
        public final String toString() {
            return GUIFileData.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GUIFileData.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GUIFileData.jvmdowngrader$equals$equals(this, o);
        }

        public String fileName() {
            return this.fileName;
        }

        public Path path() {
            return this.path;
        }

        private static String jvmdowngrader$toString$toString(GUIFileData gUIFileData) {
            GUIFileData gUIFileData2 = gUIFileData;
            return "FileAdapter$GUIFileData[" + "fileName=" + gUIFileData.fileName + ", " + "path=" + gUIFileData.path + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(GUIFileData gUIFileData) {
            Object[] objectArray = new Object[]{gUIFileData.fileName, gUIFileData.path};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(GUIFileData gUIFileData, Object object) {
            if (gUIFileData == object) {
                return true;
            }
            if (object != null && object instanceof GUIFileData) {
                GUIFileData gUIFileData2 = (GUIFileData)object;
                if (Objects.equals(gUIFileData.fileName, gUIFileData2.fileName) && Objects.equals(gUIFileData.path, gUIFileData2.path)) {
                    return true;
                }
            }
            return false;
        }
    }
}

