/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.floodgate.FloodgateUtil;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.model.player.FavouriteData;
import net.skinsrestorer.shared.storage.model.player.HistoryData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={SkinForResult.class})
public class PlayerStorageImpl
implements PlayerStorage {
    private final SettingsManager settings;
    private final SkinStorageImpl skinStorage;
    private final SRLogger logger;
    private final AdapterReference adapterReference;

    @Override
    public Optional<SkinIdentifier> getSkinIdOfPlayer(UUID uuid) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                return Optional.ofNullable(playerData.getSkinIdentifier());
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", uuid), e);
        }
        return Optional.empty();
    }

    @Override
    public void setSkinIdOfPlayer(UUID uuid, SkinIdentifier identifier) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setSkinIdentifier(identifier);
                this.adapterReference.get().setPlayerData(uuid, playerData);
            } else {
                this.adapterReference.get().setPlayerData(uuid, PlayerData.of(uuid, identifier, J_U_List.of(), J_U_List.of()));
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to set skin data of player %s", uuid), e);
        }
    }

    public Optional<HistoryData> getTopOfHistory(UUID uuid, int skip) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                return playerData.getHistory().stream().sorted(Comparator.comparing(HistoryData::getTimestamp).reversed()).skip(skip).findFirst();
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", uuid), e);
        }
        return Optional.empty();
    }

    public int getHistoryCount(UUID uuid) {
        return this.getHistoryEntries(uuid, 0, Integer.MAX_VALUE).size();
    }

    public List<HistoryData> getHistoryEntries(UUID uuid, int skip, int limit) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                return J_U_S_Stream.toList(playerData.getHistory().stream().sorted(Comparator.comparing(HistoryData::getTimestamp).reversed()).skip(skip).limit(limit));
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", uuid), e);
        }
        return J_U_List.of();
    }

    public void pushToHistory(UUID uuid, HistoryData historyData) {
        int maxHistoryLength = this.settings.getProperty(CommandConfig.MAX_HISTORY_LENGTH);
        if (maxHistoryLength <= 0) {
            return;
        }
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            boolean topIsSame = this.getTopOfHistory(uuid, 0).map(data -> data.getSkinIdentifier().equals(historyData.getSkinIdentifier())).orElse(false);
            if (topIsSame) {
                return;
            }
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setHistory(J_U_S_Stream.toList(Stream.concat(playerData.getHistory().stream(), Stream.of(historyData)).sorted(Comparator.comparing(HistoryData::getTimestamp)).skip(Math.max(0, playerData.getHistory().size() + 1 - maxHistoryLength))));
                this.adapterReference.get().setPlayerData(uuid, playerData);
            } else {
                this.adapterReference.get().setPlayerData(uuid, PlayerData.of(uuid, null, J_U_List.of(historyData), J_U_List.of()));
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to push skin data of player %s", uuid), e);
        }
    }

    public void removeFromHistory(UUID uuid, HistoryData historyData) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setHistory(J_U_S_Stream.toList(playerData.getHistory().stream().filter(data -> !data.equals(historyData))));
                this.adapterReference.get().setPlayerData(uuid, playerData);
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to remove skin data of player %s", uuid), e);
        }
    }

    public Optional<FavouriteData> getFavouriteData(UUID uuid, SkinIdentifier skinIdentifier) {
        return this.getFavouriteEntries(uuid, 0, Integer.MAX_VALUE).stream().filter(data -> data.getSkinIdentifier().equals(skinIdentifier)).findFirst();
    }

    public int getFavouriteCount(UUID uuid) {
        return this.getFavouriteEntries(uuid, 0, Integer.MAX_VALUE).size();
    }

    public List<FavouriteData> getFavouriteEntries(UUID uuid, int skip, int limit) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                return J_U_S_Stream.toList(playerData.getFavourites().stream().sorted(Comparator.comparing(FavouriteData::getTimestamp).reversed()).skip(skip).limit(limit));
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", uuid), e);
        }
        return J_U_List.of();
    }

    public void addFavourite(UUID uuid, FavouriteData favouriteData) {
        int maxFavourites = this.settings.getProperty(CommandConfig.MAX_FAVOURITE_LENGTH);
        if (maxFavourites <= 0) {
            return;
        }
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                boolean alreadyIsFavourite = playerData.getFavourites().stream().anyMatch(data -> data.getSkinIdentifier().equals(favouriteData.getSkinIdentifier()));
                if (alreadyIsFavourite) {
                    return;
                }
                playerData.setFavourites(J_U_S_Stream.toList(Stream.concat(playerData.getFavourites().stream(), Stream.of(favouriteData)).sorted(Comparator.comparing(FavouriteData::getTimestamp)).skip(Math.max(0, playerData.getHistory().size() + 1 - maxFavourites))));
                this.adapterReference.get().setPlayerData(uuid, playerData);
            } else {
                this.adapterReference.get().setPlayerData(uuid, PlayerData.of(uuid, null, J_U_List.of(), J_U_List.of(favouriteData)));
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to push skin data of player %s", uuid), e);
        }
    }

    public void removeFavourite(UUID uuid, SkinIdentifier skinIdentifier) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setFavourites(J_U_S_Stream.toList(playerData.getFavourites().stream().filter(data -> !data.getSkinIdentifier().equals(skinIdentifier))));
                this.adapterReference.get().setPlayerData(uuid, playerData);
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to remove skin data of player %s", uuid), e);
        }
    }

    @Override
    public void removeSkinIdOfPlayer(UUID uuid) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setSkinIdentifier(null);
                this.adapterReference.get().setPlayerData(uuid, playerData);
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe(J_L_String.formatted("Failed to remove skin data of player %s", uuid), e);
        }
    }

    @Override
    public Optional<SkinProperty> getSkinOfPlayer(UUID uuid) {
        return this.getSkinIdOfPlayer(uuid).flatMap(this.skinStorage::getSkinDataByIdentifier);
    }

    @Override
    public Optional<SkinIdentifier> getSkinIdForPlayer(UUID uuid, String playerName, boolean isOnlineMode) throws DataRequestException {
        return this.getSkinForPlayerResult(uuid, playerName, isOnlineMode, false).map(SkinForResult::identifier);
    }

    @Override
    public Optional<SkinProperty> getSkinForPlayer(UUID uuid, String playerName, boolean isOnlineMode) throws DataRequestException {
        return this.getSkinForPlayerResult(uuid, playerName, isOnlineMode, true).map(SkinForResult::property);
    }

    private Optional<SkinForResult> getSkinForPlayerResult(UUID uuid, String playerName, boolean isOnlineMode, boolean requireProperty) throws DataRequestException {
        Optional<SkinIdentifier> setSkin = this.getSkinIdOfPlayer(uuid);
        if (setSkin.isPresent()) {
            if (requireProperty) {
                return setSkin.flatMap(this.skinStorage::getSkinDataByIdentifier).map(property -> new SkinForResult((SkinIdentifier)setSkin.get(), (SkinProperty)property));
            }
            return Optional.of(new SkinForResult(setSkin.get(), null));
        }
        if (FloodgateUtil.isFloodgateBedrockPlayer(uuid)) {
            this.logger.debug(J_L_String.formatted("Player %s is a Floodgate player, not searching for java skin.", playerName));
            return Optional.empty();
        }
        if (isOnlineMode && !this.settings.getProperty(LoginConfig.ALWAYS_APPLY_PREMIUM).booleanValue()) {
            return Optional.empty();
        }
        boolean defaultSkinsEnabled = this.settings.getProperty(StorageConfig.DEFAULT_SKINS_ENABLED);
        if (defaultSkinsEnabled && this.settings.getProperty(StorageConfig.DEFAULT_SKINS_PREMIUM).booleanValue()) {
            return this.getDefaultSkin();
        }
        Optional<MojangSkinDataResult> premiumSkin = this.skinStorage.getPlayerSkin(playerName, false);
        if (premiumSkin.isPresent()) {
            return premiumSkin.map(result -> new SkinForResult(SkinIdentifier.ofPlayer(result.getUniqueId()), result.getSkinProperty()));
        }
        if (defaultSkinsEnabled) {
            return this.getDefaultSkin();
        }
        return Optional.empty();
    }

    private Optional<SkinForResult> getDefaultSkin() {
        List<String> skins = this.settings.getProperty(StorageConfig.DEFAULT_SKINS);
        if (skins.isEmpty()) {
            return Optional.empty();
        }
        String selectedSkin = skins.size() == 1 ? net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List.getFirst(skins) : SRHelpers.getRandomEntry(skins);
        return this.skinStorage.findSkinData(selectedSkin).map(result -> new SkinForResult(result.getIdentifier(), result.getProperty()));
    }

    @Inject
    @Generated
    public PlayerStorageImpl(SettingsManager settings, SkinStorageImpl skinStorage, SRLogger logger, AdapterReference adapterReference) {
        this.settings = settings;
        this.skinStorage = skinStorage;
        this.logger = logger;
        this.adapterReference = adapterReference;
    }

    @RecordComponents(value={@RecordComponents.Value(name="identifier", type=SkinIdentifier.class), @RecordComponents.Value(name="property", type=SkinProperty.class)})
    @NestHost(value=PlayerStorageImpl.class)
    private static final class SkinForResult
    extends J_L_Record {
        private final SkinIdentifier identifier;
        private final SkinProperty property;

        SkinForResult(SkinIdentifier identifier, SkinProperty property) {
            this.identifier = identifier;
            this.property = property;
        }

        @Override
        public final String toString() {
            return SkinForResult.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return SkinForResult.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return SkinForResult.jvmdowngrader$equals$equals(this, o);
        }

        public SkinIdentifier identifier() {
            return this.identifier;
        }

        public SkinProperty property() {
            return this.property;
        }

        private static String jvmdowngrader$toString$toString(SkinForResult skinForResult) {
            SkinForResult skinForResult2 = skinForResult;
            return "PlayerStorageImpl$SkinForResult[" + "identifier=" + skinForResult.identifier + ", " + "property=" + skinForResult.property + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(SkinForResult skinForResult) {
            Object[] objectArray = new Object[]{skinForResult.identifier, skinForResult.property};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(SkinForResult skinForResult, Object object) {
            if (skinForResult == object) {
                return true;
            }
            if (object != null && object instanceof SkinForResult) {
                SkinForResult skinForResult2 = (SkinForResult)object;
                if (Objects.equals(skinForResult.identifier, skinForResult2.identifier) && Objects.equals(skinForResult.property, skinForResult2.property)) {
                    return true;
                }
            }
            return false;
        }

        public SkinProperty jvmdowngrader$handleNest$net_skinsrestorer_shared_storage_PlayerStorageImpl$SkinForResult$get$property() {
            return this.property;
        }

        public void jvmdowngrader$handleNest$net_skinsrestorer_shared_storage_PlayerStorageImpl$SkinForResult$set$property(SkinProperty skinProperty) {
            this.property = skinProperty;
        }

        public SkinIdentifier jvmdowngrader$handleNest$net_skinsrestorer_shared_storage_PlayerStorageImpl$SkinForResult$get$identifier() {
            return this.identifier;
        }

        public void jvmdowngrader$handleNest$net_skinsrestorer_shared_storage_PlayerStorageImpl$SkinForResult$set$identifier(SkinIdentifier skinIdentifier) {
            this.identifier = skinIdentifier;
        }
    }
}

