/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.javax.annotation.Nonnull;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Record.class})
public class SoundParser {
    public static final float DEFAULT_VOLUME = 1.0f;
    public static final float DEFAULT_PITCH = 1.0f;
    public static final Pattern NAMESPACED_SOUND_PATTERN = Pattern.compile("(?<namespace>[a-z0-9._-]+):(?<key>[a-z0-9/._-]+)");

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static List<String> split(@Nonnull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(4);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nullable
    public static Record parse(@Nullable String sound) {
        String soundName;
        if (SoundParser.isNullOrEmpty(sound) || sound.equalsIgnoreCase("none")) {
            return null;
        }
        List<String> split = SoundParser.split(sound.replace(" ", ""), ',');
        Record record = new Record();
        String name = J_U_List.getFirst(split);
        if (name.charAt(0) == '~') {
            name = name.substring(1);
            record.publicSound(true);
        } else {
            record.publicSound(false);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(SoundParser.jvmdowngrader$concat$parse$1(sound));
        }
        int atIndex = name.indexOf(64);
        if (atIndex != -1) {
            String category = name.substring(0, atIndex);
            soundName = name.substring(atIndex + 1);
            String soundCategory = category.toUpperCase(Locale.ENGLISH);
            record.inCategory(soundCategory);
        } else {
            soundName = name;
        }
        if (soundName.isEmpty()) {
            throw new IllegalArgumentException(SoundParser.jvmdowngrader$concat$parse$1(name));
        }
        record.withSound(soundName.toUpperCase(Locale.ENGLISH));
        try {
            if (split.size() > 1) {
                record.withVolume(Float.parseFloat(split.get(1)));
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(SoundParser.jvmdowngrader$concat$parse$1(split.get(1), sound));
        }
        try {
            if (split.size() > 2) {
                record.withPitch(Float.parseFloat(split.get(2)));
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(SoundParser.jvmdowngrader$concat$parse$2(split.get(2), sound));
        }
        try {
            if (split.size() > 3) {
                record.withSeed(Long.parseLong(split.get(3)));
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(SoundParser.jvmdowngrader$concat$parse$3(split.get(3), sound));
        }
        return record;
    }

    private static String jvmdowngrader$concat$parse$1(String string) {
        return "No sound name specified: " + string;
    }

    private static String jvmdowngrader$concat$parse$1(String string, String string2) {
        return "Invalid number '" + string + "' for sound volume '" + string2 + "'";
    }

    private static String jvmdowngrader$concat$parse$2(String string, String string2) {
        return "Invalid number '" + string + "' for sound pitch '" + string2 + "'";
    }

    private static String jvmdowngrader$concat$parse$3(String string, String string2) {
        return "Invalid number '" + string + "' for sound seed '" + string2 + "'";
    }

    @NestHost(value=SoundParser.class)
    public static class Record {
        private static final Random RANDOM = new Random();
        private String sound;
        @Nonnull
        private String category = "MASTER";
        @Nullable
        private Long seed;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private boolean publicSound;

        @Nullable
        public Long getSeed() {
            return this.seed;
        }

        public String getSound() {
            return this.sound;
        }

        @Nonnull
        public String getCategory() {
            return this.category;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void inCategory(String category) {
            this.category = Objects.requireNonNull(category, "Sound category cannot be null");
        }

        public void withSound(@Nonnull String sound) {
            this.sound = Objects.requireNonNull(sound, "Cannot play a null sound").toLowerCase(Locale.ENGLISH);
        }

        public long generateSeed() {
            return this.seed == null ? RANDOM.nextLong() : this.seed.longValue();
        }

        public void withVolume(float volume) {
            this.volume = volume;
        }

        public void publicSound(boolean publicSound) {
            this.publicSound = publicSound;
        }

        public void withPitch(float pitch) {
            this.pitch = pitch;
        }

        public void withSeed(Long seed) {
            this.seed = seed;
        }
    }
}

