/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import lombok.Generated;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shared.log.ANSIConverter;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRPlatformLogger;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class SRLogger {
    private final SRPlatformLogger logger;
    private final boolean color;
    private boolean debug = false;

    public void debug(String message) {
        this.debug(SRLogLevel.INFO, message);
    }

    public void debug(String message, Throwable thrown) {
        this.debug(SRLogLevel.WARNING, message, thrown);
    }

    public void debug(Throwable thrown) {
        this.debug(SRLogLevel.WARNING, "Received error", thrown);
    }

    public void debug(SRLogLevel level, String message) {
        if (!this.debug) {
            return;
        }
        this.log(level, message);
    }

    public void debug(SRLogLevel level, String message, Throwable thrown) {
        if (!this.debug) {
            return;
        }
        this.log(level, message, thrown);
    }

    public void info(String message) {
        this.log(SRLogLevel.INFO, message);
    }

    public void info(String message, Throwable thrown) {
        this.log(SRLogLevel.INFO, message, thrown);
    }

    public void warning(String message) {
        this.log(SRLogLevel.WARNING, message);
    }

    public void warning(String message, Throwable thrown) {
        this.log(SRLogLevel.WARNING, message, thrown);
    }

    public void severe(String message) {
        this.log(SRLogLevel.SEVERE, message);
    }

    public void severe(String message, Throwable thrown) {
        this.log(SRLogLevel.SEVERE, message, thrown);
    }

    private void log(SRLogLevel level, String message) {
        this.logger.log(level, this.formatMessage(level, message));
    }

    private void log(SRLogLevel level, String message, Throwable thrown) {
        this.logger.log(level, this.formatMessage(level, message), thrown);
    }

    private String formatMessage(SRLogLevel level, String message) {
        String string;
        if (this.color) {
            String string2;
            Object[] objectArray = new Object[2];
            switch (level) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case INFO: {
                    string2 = "";
                    break;
                }
                case WARNING: {
                    string2 = "\u00a7e";
                    break;
                }
                case SEVERE: {
                    string2 = "\u00a7c";
                }
            }
            objectArray[0] = string2;
            objectArray[1] = message;
            string = J_L_String.formatted("\u00a7e[\u00a72SkinsRestorer\u00a7e] \u00a7r%s%s", objectArray);
        } else {
            string = message;
        }
        message = string;
        message = SRLogger.jvmdowngrader$concat$formatMessage$1(message);
        message = ANSIConverter.convertToAnsi(message);
        return message;
    }

    @Generated
    public SRLogger(SRPlatformLogger logger, boolean color) {
        this.logger = logger;
        this.color = color;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private static String jvmdowngrader$concat$formatMessage$1(String string) {
        return string + "\u00a7r";
    }
}

