/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.info;

import java.util.Arrays;
import java.util.Objects;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.info.ClassInfo;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PlatformType;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="hybrid", type=boolean.class), @RecordComponents.Value(name="platform", type=Platform.class), @RecordComponents.Value(name="platformType", type=PlatformType.class), @RecordComponents.Value(name="classInfo", type=ClassInfo.class)})
public final class EnvironmentInfo
extends J_L_Record {
    private final boolean hybrid;
    private final Platform platform;
    private final PlatformType platformType;
    private final ClassInfo classInfo;

    public EnvironmentInfo(boolean hybrid, Platform platform, PlatformType platformType, ClassInfo classInfo) {
        this.hybrid = hybrid;
        this.platform = platform;
        this.platformType = platformType;
        this.classInfo = classInfo;
    }

    public static EnvironmentInfo determineEnvironment(SRPlatformAdapter adapter) {
        ClassInfo info = ClassInfo.get();
        Platform platform = adapter.getPlatform();
        boolean hybrid = platform == Platform.BUNGEE_CORD && info.isVelocity() || platform == Platform.VELOCITY && info.isBungeecord();
        return new EnvironmentInfo(hybrid, platform, platform.getPlatformType(), info);
    }

    @Override
    public final String toString() {
        return EnvironmentInfo.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return EnvironmentInfo.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return EnvironmentInfo.jvmdowngrader$equals$equals(this, o);
    }

    public boolean hybrid() {
        return this.hybrid;
    }

    public Platform platform() {
        return this.platform;
    }

    public PlatformType platformType() {
        return this.platformType;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    private static String jvmdowngrader$toString$toString(EnvironmentInfo environmentInfo) {
        EnvironmentInfo environmentInfo2 = environmentInfo;
        return "EnvironmentInfo[" + "hybrid=" + environmentInfo.hybrid + ", " + "platform=" + (Object)((Object)environmentInfo.platform) + ", " + "platformType=" + (Object)((Object)environmentInfo.platformType) + ", " + "classInfo=" + environmentInfo.classInfo + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(EnvironmentInfo environmentInfo) {
        Object[] objectArray = new Object[]{environmentInfo.hybrid, environmentInfo.platform, environmentInfo.platformType, environmentInfo.classInfo};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(EnvironmentInfo environmentInfo, Object object) {
        if (environmentInfo == object) {
            return true;
        }
        if (object != null && object instanceof EnvironmentInfo) {
            EnvironmentInfo environmentInfo2 = (EnvironmentInfo)object;
            if (environmentInfo.hybrid == environmentInfo2.hybrid && Objects.equals((Object)environmentInfo.platform, (Object)environmentInfo2.platform) && Objects.equals((Object)environmentInfo.platformType, (Object)environmentInfo2.platformType) && Objects.equals(environmentInfo.classInfo, environmentInfo2.classInfo)) {
                return true;
            }
        }
        return false;
    }
}

