/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.hooks;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.utils.TagsUtils;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import net.skinsrestorer.shared.subjects.SRPlayer;

public class SRMiniPlaceholdersAPIExpansion<P> {
    private final SRPlatformAdapter adapter;
    private final Predicate<Object> playerPredicate;
    private final Function<P, SRPlayer> playerProvider;

    public void register() {
        Expansion.Builder builder = Expansion.builder((String)"skinsrestorer");
        builder.filter(this.playerPredicate::test);
        builder.audiencePlaceholder("skin_name_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            Optional<SkinIdentifier> skin = SkinsRestorerProvider.get().getPlayerStorage().getSkinIdOfPlayer(player.getUniqueId());
            if (skin.isPresent()) {
                return Tag.preProcessParsed((String)skin.get().getIdentifier());
            }
            return TagsUtils.EMPTY_TAG;
        });
        builder.audiencePlaceholder("skin_name_or_player_name", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            Optional<SkinIdentifier> skin = SkinsRestorerProvider.get().getPlayerStorage().getSkinIdOfPlayer(player.getUniqueId());
            return (Tag)skin.map(skinIdentifier -> Tag.preProcessParsed((String)skinIdentifier.getIdentifier())).orElseGet(() -> Tag.preProcessParsed((String)player.getName()));
        });
        builder.audiencePlaceholder("texture_url_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElse(TagsUtils.EMPTY_TAG);
        });
        builder.audiencePlaceholder("texture_url_or_steve", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElseGet(() -> this.extractTextureUrl(HardcodedSkins.STEVE.getProperty()));
        });
        builder.audiencePlaceholder("texture_url_or_alex", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElseGet(() -> this.extractTextureUrl(HardcodedSkins.ALEX.getProperty()));
        });
        builder.audiencePlaceholder("texture_id_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElse(TagsUtils.EMPTY_TAG);
        });
        builder.audiencePlaceholder("texture_id_or_steve", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElseGet(() -> this.extractTextureHash(HardcodedSkins.STEVE.getProperty()));
        });
        builder.audiencePlaceholder("texture_id_or_alex", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElseGet(() -> this.extractTextureHash(HardcodedSkins.ALEX.getProperty()));
        });
        ((Expansion)builder.build()).register();
    }

    private Tag extractTextureUrl(SkinProperty property) {
        return Tag.preProcessParsed((String)PropertyUtils.getSkinTextureUrl(property));
    }

    private Tag extractTextureHash(SkinProperty property) {
        return Tag.preProcessParsed((String)PropertyUtils.getSkinTextureHash(property));
    }

    @Inject
    @Generated
    public SRMiniPlaceholdersAPIExpansion(SRPlatformAdapter adapter, Predicate<Object> playerPredicate, Function<P, SRPlayer> playerProvider) {
        this.adapter = adapter;
        this.playerPredicate = playerPredicate;
        this.playerProvider = playerProvider;
    }
}

