/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.gui;

import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.codec.SRProxyPluginMessage;
import net.skinsrestorer.shared.gui.ClickEventType;
import net.skinsrestorer.shared.gui.GUISkinEntry;
import net.skinsrestorer.shared.gui.PageInfo;
import net.skinsrestorer.shared.gui.PageType;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;

public class SharedGUI {
    public static final int HEAD_COUNT_PER_PAGE = 36;
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;

    public SRInventory createGUIPage(SRPlayer player, PageInfo pageInfo) {
        HashMap<Integer, SRInventory.Item> items = new HashMap<Integer, SRInventory.Item>();
        int skinCount = 0;
        for (GUISkinEntry entry : pageInfo.skinList()) {
            if (skinCount >= 36) {
                this.logger.warning("SkinsGUI: Skin count is more than 36, skipping...");
                break;
            }
            HashMap<ClickEventType, SRInventory.ClickEventAction> actions = new HashMap<ClickEventType, SRInventory.ClickEventAction>();
            actions.put(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.SetSkinPayload(entry.skinIdentifier())), true));
            actions.put(ClickEventType.SHIFT_LEFT, new SRInventory.ClickEventAction(J_U_List.of(new SRProxyPluginMessage.GUIActionChannelPayload((SRProxyPluginMessage.GUIActionChannelPayload.GUIActionPayload<?>)((Object)(entry.isFavourite() ? new SRProxyPluginMessage.GUIActionChannelPayload.RemoveFavouritePayload(entry.skinIdentifier()) : new SRProxyPluginMessage.GUIActionChannelPayload.AddFavouritePayload(entry.skinIdentifier())))), new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(pageInfo.page(), pageInfo.pageType()))), false));
            items.put(skinCount, new SRInventory.Item(SRInventory.MaterialType.SKULL, entry.skinName(), entry.lore(), Optional.of(entry.textureHash()), entry.isFavourite(), actions));
            ++skinCount;
        }
        if (pageInfo.hasPrevious()) {
            items.put(48, new SRInventory.Item(SRInventory.MaterialType.ARROW, this.locale.getMessageRequired(player, Message.SKINSMENU_PREVIOUS_PAGE, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(pageInfo.page() - 1, pageInfo.pageType())), false)))));
        } else if (pageInfo.pageType() != PageType.SELECT) {
            items.put(48, new SRInventory.Item(SRInventory.MaterialType.ARROW, this.locale.getMessageRequired(player, Message.SKINSMENU_BACK_SELECT_BUTTON, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(0, PageType.SELECT)), false)))));
        }
        items.put(49, new SRInventory.Item(SRInventory.MaterialType.BARRIER, this.locale.getMessageRequired(player, Message.SKINSMENU_CLEAR_SKIN, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.ClearSkinPayload()), true)))));
        if (pageInfo.hasNext()) {
            items.put(50, new SRInventory.Item(SRInventory.MaterialType.ARROW, this.locale.getMessageRequired(player, Message.SKINSMENU_NEXT_PAGE, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(pageInfo.page() + 1, pageInfo.pageType())), false)))));
        }
        if (pageInfo.pageType() == PageType.SELECT) {
            items.put(20, new SRInventory.Item(SRInventory.MaterialType.BOOKSHELF, this.locale.getMessageRequired(player, Message.SKINSMENU_MAIN_BUTTON, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(0, PageType.MAIN)), false)))));
            items.put(22, new SRInventory.Item(SRInventory.MaterialType.ENDER_EYE, this.locale.getMessageRequired(player, Message.SKINSMENU_HISTORY_BUTTON, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(0, PageType.HISTORY)), false)))));
            items.put(24, new SRInventory.Item(SRInventory.MaterialType.ENCHANTING_TABLE, this.locale.getMessageRequired(player, Message.SKINSMENU_FAVOURITES_BUTTON, new TagResolver[0]), J_U_List.of(), Optional.empty(), false, J_U_Map.ofEntries(J_U_Map.entry(ClickEventType.LEFT, new SRInventory.ClickEventAction(new SRProxyPluginMessage.GUIActionChannelPayload(new SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload(0, PageType.FAVOURITES)), false)))));
        }
        return new SRInventory(6, this.locale.getMessageRequired(player, pageInfo.pageType().getTitle(), Placeholder.parsed("page_number", String.valueOf(pageInfo.page() + 1))), items);
    }

    @Inject
    @Generated
    public SharedGUI(SkinsRestorerLocale locale, SRLogger logger) {
        this.locale = locale;
        this.logger = logger;
    }
}

