/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.gui.GUISkinEntry;
import net.skinsrestorer.shared.gui.PageInfo;
import net.skinsrestorer.shared.gui.PageType;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.SkinPermissionManager;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={GUIRawSkinEntry.class, GUIDataSource.class})
public class GUIUtils {
    public static PageInfo getGUIPage(SRPlayer player, SkinsRestorerLocale locale, SettingsManager settings, PlayerStorageImpl playerStorage, SkinPermissionManager permissionManager, int page, PageType pageType, GUIDataSource ... sources) {
        if (page < 0) {
            page = 0;
        }
        List<GUIDataSource> enabledSources = J_U_S_Stream.toList(Arrays.stream(sources).filter(GUIDataSource::isEnabled).filter(source -> source.getPageType() == pageType).sorted(Comparator.comparingInt(GUIDataSource::getIndex)));
        int offset = page * 36;
        ArrayList<GUISkinEntry> skinPage = new ArrayList<GUISkinEntry>(36);
        boolean hasNextPage = false;
        int currentIndex = 0;
        for (GUIDataSource source2 : enabledSources) {
            int sourceTotal = source2.getTotalSkins();
            if (currentIndex + sourceTotal <= offset) {
                currentIndex += sourceTotal;
                continue;
            }
            int sourceOffset = offset - currentIndex;
            int sourceLimit = 36 - skinPage.size();
            if (sourceOffset < 0) {
                sourceLimit += sourceOffset;
                sourceOffset = 0;
            }
            List<GUIRawSkinEntry> sourceSkins = source2.getGUISkins(sourceOffset, sourceLimit);
            sourceSkins.stream().map(base -> {
                Optional<Object> favouriteData;
                ArrayList<ComponentString> lore = new ArrayList<ComponentString>();
                boolean canSetSkin = J_U_Optional.isEmpty(permissionManager.canSetSkin(player, base.skinIdentifier().getIdentifier()));
                String textureHash = canSetSkin ? base.textureHash() : settings.getProperty(GUIConfig.NOT_UNLOCKED_SKIN);
                if (canSetSkin) {
                    lore.add(locale.getMessageRequired(player, Message.SKINSMENU_SELECT_SKIN, new TagResolver[0]));
                    favouriteData = playerStorage.getFavouriteData(player.getUniqueId(), base.skinIdentifier());
                    if (favouriteData.isPresent()) {
                        lore.add(locale.getMessageRequired(player, Message.SKINSMENU_REMOVE_FAVOURITE_LORE, new TagResolver[0]));
                    } else {
                        lore.add(locale.getMessageRequired(player, Message.SKINSMENU_SET_FAVOURITE_LORE, new TagResolver[0]));
                    }
                    favouriteData.ifPresent(data -> lore.add(locale.getMessageRequired(player, Message.SKINSMENU_FAVOURITE_SINCE_LORE, Placeholder.unparsed("time", SRHelpers.formatEpochSeconds(settings, data.getTimestamp(), player.getLocale())))));
                    lore.addAll(base.extraLore());
                } else {
                    favouriteData = Optional.empty();
                    lore.add(locale.getMessageRequired(player, Message.SKINSMENU_NO_PERMISSION, new TagResolver[0]));
                }
                return new GUISkinEntry(base.skinIdentifier(), base.skinName(), textureHash, lore, favouriteData.isPresent());
            }).forEach(skinPage::add);
            if (sourceSkins.size() >= sourceTotal - sourceOffset) continue;
            hasNextPage = true;
            break;
        }
        return new PageInfo(page, pageType, page > 0, page < Integer.MAX_VALUE && hasNextPage, skinPage);
    }

    @NestHost(value=GUIUtils.class)
    public static interface GUIDataSource {
        public boolean isEnabled();

        public PageType getPageType();

        public int getIndex();

        public int getTotalSkins();

        public List<GUIRawSkinEntry> getGUISkins(int var1, int var2);
    }

    @RecordComponents(value={@RecordComponents.Value(name="skinIdentifier", type=SkinIdentifier.class), @RecordComponents.Value(name="skinName", type=ComponentString.class), @RecordComponents.Value(name="textureHash", type=String.class), @RecordComponents.Value(name="extraLore", type=List.class)})
    @NestHost(value=GUIUtils.class)
    public static final class GUIRawSkinEntry
    extends J_L_Record {
        private final SkinIdentifier skinIdentifier;
        private final ComponentString skinName;
        private final String textureHash;
        private final List<ComponentString> extraLore;

        public GUIRawSkinEntry(SkinIdentifier skinIdentifier, ComponentString skinName, String textureHash, List<ComponentString> extraLore) {
            this.skinIdentifier = skinIdentifier;
            this.skinName = skinName;
            this.textureHash = textureHash;
            this.extraLore = extraLore;
        }

        @Override
        public final String toString() {
            return GUIRawSkinEntry.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GUIRawSkinEntry.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GUIRawSkinEntry.jvmdowngrader$equals$equals(this, o);
        }

        public SkinIdentifier skinIdentifier() {
            return this.skinIdentifier;
        }

        public ComponentString skinName() {
            return this.skinName;
        }

        public String textureHash() {
            return this.textureHash;
        }

        public List<ComponentString> extraLore() {
            return this.extraLore;
        }

        private static String jvmdowngrader$toString$toString(GUIRawSkinEntry gUIRawSkinEntry) {
            GUIRawSkinEntry gUIRawSkinEntry2 = gUIRawSkinEntry;
            return "GUIUtils$GUIRawSkinEntry[" + "skinIdentifier=" + gUIRawSkinEntry.skinIdentifier + ", " + "skinName=" + gUIRawSkinEntry.skinName + ", " + "textureHash=" + gUIRawSkinEntry.textureHash + ", " + "extraLore=" + gUIRawSkinEntry.extraLore + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(GUIRawSkinEntry gUIRawSkinEntry) {
            Object[] objectArray = new Object[]{gUIRawSkinEntry.skinIdentifier, gUIRawSkinEntry.skinName, gUIRawSkinEntry.textureHash, gUIRawSkinEntry.extraLore};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(GUIRawSkinEntry gUIRawSkinEntry, Object object) {
            if (gUIRawSkinEntry == object) {
                return true;
            }
            if (object != null && object instanceof GUIRawSkinEntry) {
                GUIRawSkinEntry gUIRawSkinEntry2 = (GUIRawSkinEntry)object;
                if (Objects.equals(gUIRawSkinEntry.skinIdentifier, gUIRawSkinEntry2.skinIdentifier) && Objects.equals(gUIRawSkinEntry.skinName, gUIRawSkinEntry2.skinName) && Objects.equals(gUIRawSkinEntry.textureHash, gUIRawSkinEntry2.textureHash) && Objects.equals(gUIRawSkinEntry.extraLore, gUIRawSkinEntry2.extraLore)) {
                    return true;
                }
            }
            return false;
        }
    }
}

