/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_I_InputStream;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.log.SRLogger;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={RequestBody.class, HttpType.class, HttpMethod.class})
public class HttpClient {
    private final SRLogger logger;
    private final SettingsManager settings;

    public HttpResponse execute(URI uri, RequestBody requestBody, HttpType accepts, String userAgent, HttpMethod method, Map<String, String> headers, int timeout) throws IOException {
        InputStream is;
        if (this.settings.getProperty(AdvancedConfig.NO_CONNECTIONS).booleanValue()) {
            throw new IOException("Connections are disabled.");
        }
        long start = System.currentTimeMillis();
        URL url = uri.toURL();
        if (!url.getProtocol().equals("https")) {
            throw new IOException("Only HTTPS is supported.");
        }
        this.logger.debug(J_L_String.formatted("Sending %s request to %s with body: %s", new Object[]{method, url, requestBody}));
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod(method.name());
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Accept", accepts.getContentType());
        connection.setRequestProperty("User-Agent", userAgent);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoOutput(requestBody != null);
        if (requestBody != null) {
            connection.setRequestProperty("Content-Type", requestBody.type().getContentType());
            byte[] body = requestBody.body().getBytes(StandardCharsets.UTF_8);
            connection.setFixedLengthStreamingMode(body.length);
            try (OutputStream output = connection.getOutputStream();){
                output.write(body);
            }
        }
        connection.connect();
        try {
            is = connection.getInputStream();
        }
        catch (IOException e) {
            this.logger.debug("Failed to get input stream, falling back to error stream.", e);
            is = connection.getErrorStream();
        }
        if (is == null) {
            throw new IOException("Failed to get input stream.");
        }
        HttpResponse response = new HttpResponse(connection.getResponseCode(), new String(J_I_InputStream.readAllBytes(is), StandardCharsets.UTF_8), connection.getHeaderFields());
        this.logger.debug(J_L_String.formatted("Response body: %s", response.body().replace("\n", "").replace("\r", "")));
        this.logger.debug(J_L_String.formatted("Response code: %d", response.statusCode()));
        this.logger.debug(J_L_String.formatted("Request took %dms.", System.currentTimeMillis() - start));
        return response;
    }

    @Inject
    @Generated
    public HttpClient(SRLogger logger, SettingsManager settings) {
        this.logger = logger;
        this.settings = settings;
    }

    @NestHost(value=HttpClient.class)
    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }

    @NestHost(value=HttpClient.class)
    public static enum HttpType {
        JSON("application/json");

        private final String contentType;

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        private HttpType(String contentType) {
            this.contentType = contentType;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="body", type=String.class), @RecordComponents.Value(name="type", type=HttpType.class)})
    @NestHost(value=HttpClient.class)
    public static final class RequestBody
    extends J_L_Record {
        private final String body;
        private final HttpType type;

        public RequestBody(String body, HttpType type) {
            this.body = body;
            this.type = type;
        }

        @Override
        public final String toString() {
            return RequestBody.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return RequestBody.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return RequestBody.jvmdowngrader$equals$equals(this, o);
        }

        public String body() {
            return this.body;
        }

        public HttpType type() {
            return this.type;
        }

        private static String jvmdowngrader$toString$toString(RequestBody requestBody) {
            RequestBody requestBody2 = requestBody;
            return "HttpClient$RequestBody[" + "body=" + requestBody.body + ", " + "type=" + (Object)((Object)requestBody.type) + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(RequestBody requestBody) {
            Object[] objectArray = new Object[]{requestBody.body, requestBody.type};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(RequestBody requestBody, Object object) {
            if (requestBody == object) {
                return true;
            }
            if (object != null && object instanceof RequestBody) {
                RequestBody requestBody2 = (RequestBody)object;
                if (Objects.equals(requestBody.body, requestBody2.body) && Objects.equals((Object)requestBody.type, (Object)requestBody2.type)) {
                    return true;
                }
            }
            return false;
        }
    }
}

