/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.skinsrestorer.api.connections.MojangAPI;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.responses.profile.EclipseProfileResponse;
import net.skinsrestorer.shared.connections.responses.profile.MineToolsProfileResponse;
import net.skinsrestorer.shared.connections.responses.profile.MojangProfileResponse;
import net.skinsrestorer.shared.connections.responses.profile.PropertyResponse;
import net.skinsrestorer.shared.connections.responses.uuid.EclipseUUIDResponse;
import net.skinsrestorer.shared.connections.responses.uuid.MineToolsUUIDResponse;
import net.skinsrestorer.shared.connections.responses.uuid.MojangUUIDResponse;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.UUIDUtils;
import net.skinsrestorer.shared.utils.ValidationUtil;

public class MojangAPIImpl
implements MojangAPI {
    private static final String UUID_ECLIPSE = "https://eclipse.skinsrestorer.net/mojang/uuid/%playerName%";
    private static final String UUID_MOJANG = "https://api.mojang.com/users/profiles/minecraft/%playerName%";
    private static final String UUID_MINETOOLS = "https://api.minetools.eu/uuid/%playerName%";
    private static final String PROFILE_ECLIPSE = "https://eclipse.skinsrestorer.net/mojang/skin/%uuid%";
    private static final String PROFILE_MOJANG = "https://sessionserver.mojang.com/session/minecraft/profile/%uuid%?unsigned=false";
    private static final String PROFILE_MINETOOLS = "https://api.minetools.eu/profile/%uuid%";
    private final MetricsCounter metricsCounter;
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final HttpClient httpClient;

    @Override
    public Optional<MojangSkinDataResult> getSkin(String nameOrUniqueId) throws DataRequestException {
        Optional<UUID> uuidResult;
        Optional<UUID> uuidParseResult = UUIDUtils.tryParseUniqueId(nameOrUniqueId);
        if (ValidationUtil.invalidMinecraftUsername(nameOrUniqueId) && J_U_Optional.isEmpty(uuidParseResult)) {
            return Optional.empty();
        }
        Optional<UUID> optional = uuidResult = J_U_Optional.isEmpty(uuidParseResult) ? this.getUUID(nameOrUniqueId) : uuidParseResult;
        if (J_U_Optional.isEmpty(uuidResult)) {
            return Optional.empty();
        }
        return this.getProfile(uuidResult.get()).flatMap(propertyResponse -> Optional.of(MojangSkinDataResult.of((UUID)uuidResult.get(), propertyResponse)));
    }

    @Override
    public Optional<UUID> getUUID(String playerName) throws DataRequestException {
        if (ValidationUtil.invalidMinecraftUsername(playerName)) {
            return Optional.empty();
        }
        try {
            return this.getUUIDEclipse(playerName);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            try {
                return this.getUUIDMojang(playerName);
            }
            catch (DataRequestException e2) {
                this.logger.debug(e2);
                try {
                    return this.getUUIDMineTools(playerName);
                }
                catch (DataRequestException e3) {
                    this.logger.debug(e3);
                    throw new DataRequestExceptionShared(J_L_String.formatted("Failed to get UUID for player: %s", playerName));
                }
            }
        }
    }

    public Optional<UUID> getUUIDEclipse(String playerName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(UUID_ECLIPSE.replace("%playerName%", playerName)), MetricsCounter.Service.ECLIPSE_UUID);
        if (httpResponse.statusCode() != 200) {
            throw new DataRequestExceptionShared(J_L_String.formatted("Eclipse error: %d", httpResponse.statusCode()));
        }
        EclipseUUIDResponse response = httpResponse.getBodyAs(EclipseUUIDResponse.class);
        return Optional.ofNullable(response.uuid());
    }

    public Optional<UUID> getUUIDMojang(String playerName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(UUID_MOJANG.replace("%playerName%", playerName)), MetricsCounter.Service.MOJANG);
        if (httpResponse.statusCode() == 204 || httpResponse.statusCode() == 404 || httpResponse.body().isEmpty()) {
            return Optional.empty();
        }
        if (httpResponse.statusCode() == 429) {
            throw new DataRequestExceptionShared("Please wait a minute before requesting that skin again. (Rate Limited)");
        }
        MojangUUIDResponse response = httpResponse.getBodyAs(MojangUUIDResponse.class);
        if (response.getError() != null) {
            throw new DataRequestExceptionShared(J_L_String.formatted("Mojang error: %s", response.getError()));
        }
        return Optional.ofNullable(response.getId()).map(UUIDUtils::convertToDashed);
    }

    protected Optional<UUID> getUUIDMineTools(String playerName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(UUID_MINETOOLS.replace("%playerName%", playerName)), MetricsCounter.Service.MINE_TOOLS, 10000);
        MineToolsUUIDResponse response = httpResponse.getBodyAs(MineToolsUUIDResponse.class);
        if (response.getStatus() != null && response.getStatus().equals("ERR")) {
            throw new DataRequestExceptionShared(J_L_String.formatted("MineTools error: %s", response.getStatus()));
        }
        return Optional.ofNullable(response.getId()).map(UUIDUtils::convertToDashed);
    }

    @Override
    public Optional<SkinProperty> getProfile(UUID uuid) throws DataRequestException {
        try {
            return this.getProfileEclipse(uuid);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            try {
                return this.getProfileMojang(uuid);
            }
            catch (DataRequestException e2) {
                this.logger.debug(e2);
                try {
                    return this.getProfileMineTools(uuid);
                }
                catch (DataRequestException e3) {
                    this.logger.debug(e3);
                    throw new DataRequestExceptionShared(J_L_String.formatted("Failed to get profile for player: %s", uuid));
                }
            }
        }
    }

    public Optional<SkinProperty> getProfileEclipse(UUID uuid) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(PROFILE_ECLIPSE.replace("%uuid%", uuid.toString())), MetricsCounter.Service.ECLIPSE_PROFILE);
        if (httpResponse.statusCode() != 200) {
            throw new DataRequestExceptionShared(J_L_String.formatted("Eclipse error: %d", httpResponse.statusCode()));
        }
        EclipseProfileResponse response = httpResponse.getBodyAs(EclipseProfileResponse.class);
        if (response.skinProperty() == null) {
            return Optional.empty();
        }
        return Optional.of(SkinProperty.of(response.skinProperty().value(), response.skinProperty().signature()));
    }

    public Optional<SkinProperty> getProfileMojang(UUID uuid) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(PROFILE_MOJANG.replace("%uuid%", UUIDUtils.convertToNoDashes(uuid))), MetricsCounter.Service.MOJANG);
        MojangProfileResponse response = httpResponse.getBodyAs(MojangProfileResponse.class);
        if (response.getProperties() == null) {
            return Optional.empty();
        }
        PropertyResponse property = response.getProperties()[0];
        if (property.getValue().isEmpty() || property.getSignature().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SkinProperty.of(property.getValue(), property.getSignature()));
    }

    protected Optional<SkinProperty> getProfileMineTools(UUID uuid) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(PROFILE_MINETOOLS.replace("%uuid%", UUIDUtils.convertToNoDashes(uuid))), MetricsCounter.Service.MINE_TOOLS, 10000);
        MineToolsProfileResponse response = httpResponse.getBodyAs(MineToolsProfileResponse.class);
        if (response.getRaw() == null) {
            return Optional.empty();
        }
        MineToolsProfileResponse.Raw raw = response.getRaw();
        if (raw.getStatus() != null && raw.getStatus().equals("ERR")) {
            throw new DataRequestExceptionShared(J_L_String.formatted("MineTools error: %s", raw.getStatus()));
        }
        PropertyResponse property = raw.getProperties()[0];
        if (property.getValue().isEmpty() || property.getSignature().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SkinProperty.of(property.getValue(), property.getSignature()));
    }

    private HttpResponse readURL(URI uri, MetricsCounter.Service service) throws DataRequestException {
        return this.readURL(uri, service, 5000);
    }

    private HttpResponse readURL(URI uri, MetricsCounter.Service service, int timeout) throws DataRequestException {
        this.metricsCounter.increment(service);
        try {
            return this.httpClient.execute(uri, null, HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.GET, Collections.emptyMap(), timeout);
        }
        catch (IOException e) {
            this.logger.debug(J_L_String.formatted("Error while reading URL: %s", uri), e);
            throw new DataRequestExceptionShared(e);
        }
    }

    @Inject
    @Generated
    public MojangAPIImpl(MetricsCounter metricsCounter, SRLogger logger, SRPlugin plugin, HttpClient httpClient) {
        this.metricsCounter = metricsCounter;
        this.logger = logger;
        this.plugin = plugin;
        this.httpClient = httpClient;
    }
}

