/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.requests.mineskin.MineSkinUrlRequest;
import net.skinsrestorer.shared.connections.responses.mineskin.MineSkinErrorDelayResponse;
import net.skinsrestorer.shared.connections.responses.mineskin.MineSkinErrorResponse;
import net.skinsrestorer.shared.connections.responses.mineskin.MineSkinTexture;
import net.skinsrestorer.shared.connections.responses.mineskin.MineSkinUrlResponse;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.exception.MineSkinExceptionShared;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SRHelpers;

public class MineSkinAPIImpl
implements MineSkinAPI {
    private static final int MAX_RETRIES = 5;
    private static final String MINESKIN_USER_AGENT = "SkinsRestorer/MineSkinAPI";
    private static final URI MINESKIN_ENDPOINT = URI.create("https://api.mineskin.org/generate/url");
    private final ReentrantLock lock = new ReentrantLock();
    private final Gson gson = new Gson();
    private final SRLogger logger;
    private final MetricsCounter metricsCounter;
    private final SettingsManager settings;
    private final HttpClient httpClient;

    @Override
    public MineSkinResponse genSkin(String imageUrl, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException {
        imageUrl = SRHelpers.sanitizeImageURL(imageUrl);
        int retryAttempts = 0;
        do {
            this.lock.lock();
            try {
                Optional<MineSkinResponse> optional = this.genSkinInternal(imageUrl, skinVariant);
                if (optional.isPresent()) {
                    MineSkinResponse mineSkinResponse = optional.get();
                    return mineSkinResponse;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                this.logger.debug(SRLogLevel.WARNING, J_L_String.formatted("[ERROR] MineSkin Failed! IOException (connection/disk): (%s)", imageUrl), e);
                throw new DataRequestExceptionShared(e);
            }
            finally {
                this.lock.unlock();
            }
        } while (++retryAttempts < 5);
        throw new MineSkinExceptionShared(Message.ERROR_MS_API_FAILED, new TagResolver[0]);
    }

    private Optional<MineSkinResponse> genSkinInternal(String imageUrl, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException, IOException, InterruptedException {
        HttpResponse httpResponse = this.queryURL(imageUrl, skinVariant);
        this.logger.debug(J_L_String.formatted("MineSkinAPI: Response: %s", httpResponse));
        switch (httpResponse.statusCode()) {
            case 200: {
                MineSkinUrlResponse response = httpResponse.getBodyAs(MineSkinUrlResponse.class);
                MineSkinTexture texture = response.getData().getTexture();
                SkinProperty property = SkinProperty.of(texture.getValue(), texture.getSignature());
                return Optional.of(MineSkinResponse.of(property, response.getIdStr(), skinVariant, PropertyUtils.getSkinVariant(property)));
            }
            case 400: 
            case 500: {
                MineSkinErrorResponse response = httpResponse.getBodyAs(MineSkinErrorResponse.class);
                String error = response.getErrorCode();
                this.logger.debug(J_L_String.formatted("[ERROR] MineSkin Failed! Reason: %s Image URL: %s", error, imageUrl));
                switch (error) {
                    case "failed_to_create_id": 
                    case "skin_change_failed": {
                        this.logger.debug("Trying again in 6 seconds...");
                        TimeUnit.SECONDS.sleep(6L);
                        break;
                    }
                    case "no_account_available": {
                        throw new MineSkinExceptionShared(Message.ERROR_MS_FULL, new TagResolver[0]);
                    }
                    default: {
                        throw new MineSkinExceptionShared(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
                    }
                }
                return Optional.empty();
            }
            case 403: {
                MineSkinErrorResponse response = httpResponse.getBodyAs(MineSkinErrorResponse.class);
                String errorCode = response.getErrorCode();
                String error = response.getError();
                if (errorCode.equals("invalid_api_key")) {
                    this.logger.severe(J_L_String.formatted("[ERROR] MineSkin API key is invalid! Reason: %s", error));
                    switch (error) {
                        case "Invalid API Key": {
                            this.logger.severe(J_L_String.formatted("The API Key provided is not registered on MineSkin! Please empty \"%s\" in plugins/SkinsRestorer/config.yml and run /sr reload", APIConfig.MINESKIN_API_KEY.getPath()));
                            break;
                        }
                        case "Client not allowed": {
                            this.logger.severe("This server ip is not on the api key allowed IPs list!");
                            break;
                        }
                        case "Origin not allowed": {
                            this.logger.severe("This server Origin is not on the api key allowed Origins list!");
                            break;
                        }
                        case "Agent not allowed": {
                            this.logger.severe(J_L_String.formatted("SkinsRestorer's agent \"%s\" is not on the api key allowed agents list!", MINESKIN_USER_AGENT));
                            break;
                        }
                        default: {
                            this.logger.severe("Unknown error, please report this to SkinsRestorer's discord!");
                        }
                    }
                    throw new MineSkinExceptionShared(Message.ERROR_MS_API_KEY_INVALID, new TagResolver[0]);
                }
                throw new MineSkinExceptionShared(Message.ERROR_MS_UNKNOWN, new TagResolver[0]);
            }
            case 429: {
                MineSkinErrorDelayResponse response = httpResponse.getBodyAs(MineSkinErrorDelayResponse.class);
                if (response.getDelay() != null) {
                    TimeUnit.SECONDS.sleep(response.getDelay().intValue());
                } else if (response.getNextRequest() != null) {
                    Instant nextRequestInstant = Instant.ofEpochSecond(response.getNextRequest().intValue());
                    int delay = (int)Duration.between(Instant.now(), nextRequestInstant).getSeconds();
                    if (delay > 0) {
                        TimeUnit.SECONDS.sleep(delay);
                    }
                } else {
                    TimeUnit.SECONDS.sleep(6L);
                }
                return Optional.empty();
            }
        }
        this.logger.debug(J_L_String.formatted("[ERROR] MineSkin Failed! Unknown error: (Image URL: %s) %d", imageUrl, httpResponse.statusCode()));
        throw new MineSkinExceptionShared(Message.ERROR_MS_API_FAILED, new TagResolver[0]);
    }

    private HttpResponse queryURL(String url, @Nullable SkinVariant skinVariant) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.metricsCounter.increment(MetricsCounter.Service.MINE_SKIN);
                HashMap<String, String> headers = new HashMap<String, String>();
                Optional<String> apiKey = this.getApiKey(this.settings);
                apiKey.ifPresent(s -> headers.put("Authorization", J_L_String.formatted("Bearer %s", s)));
                return this.httpClient.execute(MINESKIN_ENDPOINT, new HttpClient.RequestBody(this.gson.toJson(new MineSkinUrlRequest(skinVariant, null, this.settings.getProperty(APIConfig.MINESKIN_SECRET_SKINS) != false ? 1 : 0, url)), HttpClient.HttpType.JSON), HttpClient.HttpType.JSON, MINESKIN_USER_AGENT, HttpClient.HttpMethod.POST, headers, 90000);
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new IOException(e);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private Optional<String> getApiKey(SettingsManager settings) {
        String apiKey = settings.getProperty(APIConfig.MINESKIN_API_KEY);
        if (apiKey.isEmpty() || apiKey.equals("key")) {
            return Optional.empty();
        }
        return Optional.of(apiKey);
    }

    @Inject
    @Generated
    public MineSkinAPIImpl(SRLogger logger, MetricsCounter metricsCounter, SettingsManager settings, HttpClient httpClient) {
        this.logger = logger;
        this.metricsCounter = metricsCounter;
        this.settings = settings;
        this.httpClient = httpClient;
    }
}

