/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.SettingsManagerImpl;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.GsonBuilder;
import net.skinsrestorer.shadow.gson.JsonObject;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.requests.DumpInfo;
import net.skinsrestorer.shared.connections.responses.BytebinResponse;
import net.skinsrestorer.shared.info.EnvironmentInfo;
import net.skinsrestorer.shared.info.PlatformInfo;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlugin;

public class DumpService {
    private static final URI BYTEBIN_ENDPOINT = URI.create("https://bytebin.lucko.me/post");
    private static final Function<SettingsManager, ConfigurationData> DATA_EXTRACTOR;
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final SRPlatformAdapter adapter;
    private final Injector injector;
    private final HttpClient httpClient;
    private final SettingsManager settingsManager;
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    public Optional<String> dump() throws IOException, DataRequestException {
        PlatformInfo platformInfo;
        EnvironmentInfo environmentInfo;
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        Boolean proxyMode = serverPlugin == null ? null : Boolean.valueOf(serverPlugin.isProxyMode());
        ConfigurationData configurationData = DATA_EXTRACTOR.apply(this.settingsManager);
        JsonObject configMap = new JsonObject();
        for (Property<?> key : configurationData.getProperties()) {
            if (key.getPath().startsWith("database.") || key.getPath().equals(APIConfig.MINESKIN_API_KEY.getPath())) continue;
            String[] split = key.getPath().split("\\.");
            JsonObject jsonObject = configMap;
            String keyName = split[split.length - 1];
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; ++i) {
                    if (!jsonObject.has(split[i])) {
                        jsonObject.add(split[i], new JsonObject());
                    }
                    jsonObject = jsonObject.getAsJsonObject(split[i]);
                }
            }
            jsonObject.add(keyName, this.gson.toJsonTree(configurationData.getValue(key)));
        }
        DumpInfo.PluginInfo.StorageType storageType = proxyMode != null && proxyMode != false ? DumpInfo.PluginInfo.StorageType.NONE : (this.settingsManager.getProperty(DatabaseConfig.MYSQL_ENABLED) != false ? DumpInfo.PluginInfo.StorageType.MYSQL : DumpInfo.PluginInfo.StorageType.FILE);
        DumpInfo.PluginInfo pluginInfo = new DumpInfo.PluginInfo(proxyMode, storageType, configMap);
        DumpInfo dumpInfo = new DumpInfo(new DumpInfo.BuildInfo(), pluginInfo, environmentInfo = EnvironmentInfo.determineEnvironment(this.adapter), platformInfo = new PlatformInfo(this.adapter.getPlatformName(), this.adapter.getPlatformVendor(), this.adapter.getPlatformVersion(), this.adapter.getPlugins()), new DumpInfo.OSInfo(), new DumpInfo.JavaInfo(), new DumpInfo.UserInfo());
        HttpResponse response = this.httpClient.execute(BYTEBIN_ENDPOINT, new HttpClient.RequestBody(this.gson.toJson(dumpInfo), HttpClient.HttpType.JSON), HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.POST, Collections.emptyMap(), 20000);
        if (response.statusCode() != 201) {
            this.logger.warning(J_L_String.formatted("Failed to dump data to bytebin. Response code: %d", response.statusCode()));
            return Optional.empty();
        }
        BytebinResponse responseObject = response.getBodyAs(BytebinResponse.class);
        return Optional.of(responseObject.getKey());
    }

    @Inject
    @Generated
    public DumpService(SRLogger logger, SRPlugin plugin, SRPlatformAdapter adapter, Injector injector, HttpClient httpClient, SettingsManager settingsManager) {
        this.logger = logger;
        this.plugin = plugin;
        this.adapter = adapter;
        this.injector = injector;
        this.httpClient = httpClient;
        this.settingsManager = settingsManager;
    }

    static {
        try {
            Field field = SettingsManagerImpl.class.getDeclaredField("configurationData");
            field.setAccessible(true);
            DATA_EXTRACTOR = settingsManager -> {
                try {
                    return (ConfigurationData)field.get(settingsManager);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

