/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import net.skinsrestorer.shadow.configme.Comment;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;

public class ServerConfig
implements SettingsHolder {
    @Comment(value={"Disabling this will stop SkinsRestorer from changing skins when a player loads a server resource pack.", "When a player loads a server resource pack, their skin is reset. By default, SkinsRestorer reapplies the skin when the player reports that the resource pack has been loaded or an error has occurred."})
    public static final Property<Boolean> RESOURCE_PACK_FIX = PropertyInitializer.newProperty("server.resourcePackFix", true);
    @Comment(value={"Dismounts a mounted (on a horse, or sitting) player when their skin is updated, preventing players from becoming desynced.", "File override = ./plugins/SkinsRestorer/disableDismountPlayer.txt"})
    public static final Property<Boolean> DISMOUNT_PLAYER_ON_UPDATE = PropertyInitializer.newProperty("server.dismountPlayerOnSkinUpdate", true);
    @Comment(value={"Remounts a player that was dismounted after a skin update (above option must be true).", "Disabling this is only recommended if you use plugins that allow you ride other players, or use sit. Otherwise you could get errors or players could be kicked for flying.", "File override = ./plugins/SkinsRestorer/disableRemountPlayer.txt"})
    public static final Property<Boolean> REMOUNT_PLAYER_ON_UPDATE = PropertyInitializer.newProperty("server.remountPlayerOnSkinUpdate", true);
    @Comment(value={"Dismounts all passengers mounting a player (such as plugins that let you ride another player), preventing those players from becoming desynced.", "File override = ./plugins/SkinsRestorer/enableDismountEntities.txt"})
    public static final Property<Boolean> DISMOUNT_PASSENGERS_ON_UPDATE = PropertyInitializer.newProperty("server.dismountPassengersOnSkinUpdate", false);
    @Comment(value={"Play a sound when a player runs /skin to change their skin."})
    public static final Property<Boolean> SOUND_ENABLED = PropertyInitializer.newProperty("server.sound.enabled", true);
    @Comment(value={"Sound to play when a player runs /skin to change their skin.", "You can find the allowed format and values at", "https://javadoc.io/static/com.github.cryptomorin/XSeries/11.0.0/com/cryptomorin/xseries/XSound.html#parse(java.lang.String)"})
    public static final Property<String> SOUND_VALUE = PropertyInitializer.newProperty("server.sound.value", "ENTITY_PLAYER_TELEPORT, 0.7");

    @Override
    public void registerComments(CommentsConfiguration conf) {
        conf.setComment("server", "\n", "\n##########", "\n# Server #", "\n##########", "\n", "Change server specific settings here.");
    }
}

