/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.util.List;
import net.skinsrestorer.shadow.configme.Comment;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;
import net.skinsrestorer.shared.config.ConfigHelpers;

public class GUIConfig
implements SettingsHolder {
    @Comment(value={"Control what skin is displayed when a player does not have permission for a skin.", "This is the end part of the skin texture URL.", "You can obtain the texture URL from /sr info skin <skinName>"})
    public static final Property<String> NOT_UNLOCKED_SKIN = PropertyInitializer.newProperty("gui.notUnlockedSkin", "c10591e6909e6a281b371836e462d67a2c78fa0952e910f32b41a26c48c1757c");
    @Comment(value={"Whether custom skins are enabled in the /skins GUI"})
    public static final Property<Boolean> CUSTOM_GUI_ENABLED = PropertyInitializer.newProperty("gui.custom.enabled", true);
    @Comment(value={"Order of custom skins relative to the other skin types"})
    public static final Property<Integer> CUSTOM_GUI_INDEX = ConfigHelpers.newCappedProperty("gui.custom.index", 0, 0, Integer.MAX_VALUE);
    @Comment(value={"Whether only specific custom skins are allowed in the /skins GUI"})
    public static final Property<Boolean> CUSTOM_GUI_ONLY_LIST = PropertyInitializer.newProperty("gui.custom.onlyShowList", false);
    @Comment(value={"Specific custom skins to show in the /skins GUI"})
    public static final Property<List<String>> CUSTOM_GUI_LIST = PropertyInitializer.newListProperty("gui.custom.list", "xknat", "pistonmaster");
    @Comment(value={"Whether player skins are enabled in the /skins GUI"})
    public static final Property<Boolean> PLAYERS_GUI_ENABLED = PropertyInitializer.newProperty("gui.players.enabled", false);
    @Comment(value={"Order of player skins relative to the other skin types"})
    public static final Property<Integer> PLAYERS_GUI_INDEX = ConfigHelpers.newCappedProperty("gui.players.index", 1, 0, Integer.MAX_VALUE);
    @Comment(value={"Whether only specific player skins are allowed in the /skins GUI"})
    public static final Property<Boolean> PLAYERS_GUI_ONLY_LIST = PropertyInitializer.newProperty("gui.players.onlyShowList", false);
    @Comment(value={"Specific player skins to show in the /skins GUI"})
    public static final Property<List<String>> PLAYERS_GUI_LIST = PropertyInitializer.newListProperty("gui.players.list", "7dcfc130-344a-4719-9fbe-3176bc2075c6", "b1ae0778-4817-436c-96a3-a72c67cda060");
    @Comment(value={"Whether recommended skins are enabled in the /skins GUI"})
    public static final Property<Boolean> RECOMMENDATIONS_GUI_ENABLED = PropertyInitializer.newProperty("gui.recommendations.enabled", true);
    @Comment(value={"Order of recommended skins relative to the other skin types"})
    public static final Property<Integer> RECOMMENDATIONS_GUI_INDEX = ConfigHelpers.newCappedProperty("gui.recommendations.index", 2, 0, Integer.MAX_VALUE);
    @Comment(value={"Whether only specific recommended skins are allowed in the /skins GUI"})
    public static final Property<Boolean> RECOMMENDATIONS_GUI_ONLY_LIST = PropertyInitializer.newProperty("gui.recommendations.onlyShowList", false);
    @Comment(value={"Specific recommended skins to show in the /skins GUI"})
    public static final Property<List<String>> RECOMMENDATIONS_GUI_LIST = PropertyInitializer.newListProperty("gui.recommendations.list", "vampire", "space-suit");

    @Override
    public void registerComments(CommentsConfiguration conf) {
        conf.setComment("gui", "\n", "Control what skins appear in the /skins GUI");
        conf.setComment("gui.custom", "Control custom skins in the /skins GUI");
        conf.setComment("gui.players", "Control player skins in the /skins GUI");
        conf.setComment("gui.recommendations", "Control recommended skins in the /skins GUI");
    }
}

