/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.io.IOException;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.migration.MigrationService;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;
import net.skinsrestorer.shadow.configme.properties.convertresult.PropertyValue;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.utils.SRHelpers;

public class ConfigMigratorService
implements MigrationService {
    private final SRLogger logger;
    private final SRPlugin plugin;

    @Override
    public boolean checkAndMigrate(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        return this.performMigrations(reader, configurationData) || !configurationData.areAllValuesValidInResource();
    }

    private boolean performMigrations(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        return this.migrateV14Layout(reader, configurationData) | this.migrateNewGUILayout(reader, configurationData);
    }

    private boolean migrateV14Layout(PropertyReader reader, ConfigurationData configData) {
        boolean migrated = false;
        migrated |= this.moveProperty(PropertyInitializer.newProperty("Debug", false), DevConfig.DEBUG, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Enabled", false), DatabaseConfig.MYSQL_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Host", "localhost"), DatabaseConfig.MYSQL_HOST, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Port", 3306), DatabaseConfig.MYSQL_PORT, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Database", "db"), DatabaseConfig.MYSQL_DATABASE, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Username", "root"), DatabaseConfig.MYSQL_USERNAME, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.Password", "password"), DatabaseConfig.MYSQL_PASSWORD, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MySQL.ConnectionOptions", ""), DatabaseConfig.MYSQL_CONNECTION_OPTIONS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("SkinWithoutPerm", true), CommandConfig.FORCE_DEFAULT_PERMISSIONS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("SkinChangeCooldown", 30), CommandConfig.SKIN_CHANGE_COOLDOWN, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("SkinErrorCooldown", 5), CommandConfig.SKIN_ERROR_COOLDOWN, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("EnableCustomHelp", false), CommandConfig.CUSTOM_HELP_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DisablePrefix", false), MessageConfig.DISABLE_PREFIX, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DefaultSkins.Enabled", false), StorageConfig.DEFAULT_SKINS_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DefaultSkins.ApplyForPremium", false), StorageConfig.DEFAULT_SKINS_PREMIUM, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newListProperty("DefaultSkins.Names", J_U_List.of()), StorageConfig.DEFAULT_SKINS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DisabledSkins.Enabled", false), CommandConfig.DISABLED_SKINS_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newListProperty("DisabledSkins.Names", J_U_List.of()), CommandConfig.DISABLED_SKINS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("NotAllowedCommandServers.Enabled", true), ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("NotAllowedCommandServers.AllowList", false), ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ALLOWLIST, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("NotAllowedCommandServers.IfNoServerBlockCommand", false), ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_IF_NONE_BLOCK_COMMAND, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newListProperty("NotAllowedCommandServers.List", J_U_List.of()), ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("CustomGUI.Enabled", false), GUIConfig.CUSTOM_GUI_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("CustomGUI.ShowOnlyCustomGUI", true), GUIConfig.CUSTOM_GUI_ONLY_LIST, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newListProperty("CustomGUI.Names", J_U_List.of()), GUIConfig.CUSTOM_GUI_LIST, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("PerSkinPermissions", false), CommandConfig.PER_SKIN_PERMISSIONS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("SkinExpiresAfter", 15), StorageConfig.SKIN_EXPIRES_AFTER, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("NoSkinIfLoginCanceled", true), LoginConfig.NO_SKIN_IF_LOGIN_CANCELED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("AlwaysApplyPremium", false), LoginConfig.ALWAYS_APPLY_PREMIUM, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("RestrictSkinUrls.Enabled", false), CommandConfig.RESTRICT_SKIN_URLS_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newListProperty("RestrictSkinUrls.List", J_U_List.of()), CommandConfig.RESTRICT_SKIN_URLS_LIST, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("MineskinAPIKey", "key"), APIConfig.MINESKIN_API_KEY, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("ResourcePackFix", true), ServerConfig.RESOURCE_PACK_FIX, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DismountPlayerOnSkinUpdate", true), ServerConfig.DISMOUNT_PLAYER_ON_UPDATE, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("RemountPlayerOnSkinUpdate", true), ServerConfig.REMOUNT_PLAYER_ON_UPDATE, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DismountPassengersOnSkinUpdate", false), ServerConfig.DISMOUNT_PASSENGERS_ON_UPDATE, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DisableOnJoinSkins", false), AdvancedConfig.DISABLE_ON_JOIN_SKINS, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("DisallowAutoUpdateSkin", false), StorageConfig.DISALLOW_AUTO_UPDATE_SKIN, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("EnablePaperJoinListener", true), AdvancedConfig.ENABLE_PAPER_JOIN_LISTENER, reader, configData);
        if (Boolean.TRUE.equals(configData.getValue(DatabaseConfig.MYSQL_ENABLED))) {
            Property<String> oldMySQLPlayerTable;
            Property<String> oldMySQLSkinTable = PropertyInitializer.newProperty("MySQL.SkinTable", "Skins");
            if (oldMySQLSkinTable.isValidInResource(reader)) {
                try {
                    SRHelpers.writeIfNeeded(this.plugin.getDataFolder().resolve("legacy_skin_table.txt"), oldMySQLSkinTable.determineValue(reader).getValue());
                }
                catch (IOException e) {
                    this.logger.severe("Failed to write legacy_skin_table.txt", e);
                }
            }
            if ((oldMySQLPlayerTable = PropertyInitializer.newProperty("MySQL.PlayerTable", "Players")).isValidInResource(reader)) {
                try {
                    SRHelpers.writeIfNeeded(this.plugin.getDataFolder().resolve("legacy_player_table.txt"), oldMySQLPlayerTable.determineValue(reader).getValue());
                }
                catch (IOException e) {
                    this.logger.severe("Failed to write legacy_player_table.txt", e);
                }
            }
        }
        return migrated;
    }

    private boolean migrateNewGUILayout(PropertyReader reader, ConfigurationData configData) {
        boolean migrated = false;
        migrated |= this.moveProperty(PropertyInitializer.newProperty("customGUI.enabled", true), GUIConfig.CUSTOM_GUI_ENABLED, reader, configData);
        migrated |= this.moveProperty(PropertyInitializer.newProperty("customGUI.showOnlyCustomGUI", false), GUIConfig.CUSTOM_GUI_ONLY_LIST, reader, configData);
        return migrated |= this.moveProperty(PropertyInitializer.newListProperty("customGUI.list", J_U_List.of()), GUIConfig.CUSTOM_GUI_LIST, reader, configData);
    }

    protected <T> boolean moveProperty(Property<T> oldProperty, Property<T> newProperty, PropertyReader reader, ConfigurationData configData) {
        PropertyValue<T> oldPropertyValue = oldProperty.determineValue(reader);
        if (oldPropertyValue.isValidInResource()) {
            if (reader.contains(newProperty.getPath())) {
                this.logger.info(J_L_String.formatted("Detected deprecated property %s", oldProperty.getPath()));
            } else {
                this.logger.info(J_L_String.formatted("Renaming %s to %s", oldProperty.getPath(), newProperty.getPath()));
                configData.setValue(newProperty, oldPropertyValue.getValue());
            }
            return true;
        }
        return false;
    }

    @Inject
    @Generated
    public ConfigMigratorService(SRLogger logger, SRPlugin plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }
}

