/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.util.Locale;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.TypeBasedProperty;
import net.skinsrestorer.shadow.configme.properties.types.PrimitivePropertyType;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.config.LocaleProperty;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={CappedIntegerProperty.class})
public class ConfigHelpers {
    public static Property<Integer> newCappedProperty(String path, int defaultValue, int min, int max) {
        return new CappedIntegerProperty(path, defaultValue, min, max);
    }

    public static Property<Locale> newLocaleProperty(String path, Locale defaultValue) {
        return new TypeBasedProperty<Locale>(path, defaultValue, LocaleProperty.instance());
    }

    @NestHost(value=ConfigHelpers.class)
    public static class CappedIntegerProperty
    extends TypeBasedProperty<Integer> {
        public CappedIntegerProperty(@NotNull String path, @NotNull Integer defaultValue, Integer min, Integer max) {
            super(path, defaultValue, new PrimitivePropertyType<Integer>(object -> {
                Integer n;
                if (object instanceof Number) {
                    Number num = (Number)object;
                    n = Math.min(Math.max(num.intValue(), min), max);
                } else {
                    n = null;
                }
                return n;
            }));
        }
    }
}

