/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="toResolve", type=Collection.class)})
@NestMembers(value={Selector.class, UniqueId.class, Player.class, Resolvable.class, SelectorType.class})
public final class PlayerSelector
extends J_L_Record {
    private final Collection<Resolvable> toResolve;

    public PlayerSelector(Collection<Resolvable> toResolve) {
        this.toResolve = toResolve;
    }

    public static PlayerSelector singleton(SRPlayer player) {
        return new PlayerSelector(J_U_List.of(new Player(player)));
    }

    public Collection<UUID> resolve(SRCommandSender commandSender) {
        LinkedHashSet<UUID> resolvedPlayers = new LinkedHashSet<UUID>();
        for (Resolvable resolvable : this.toResolve) {
            resolvedPlayers.addAll(resolvable.resolve(commandSender));
        }
        return resolvedPlayers;
    }

    @Override
    public final String toString() {
        return PlayerSelector.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return PlayerSelector.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return PlayerSelector.jvmdowngrader$equals$equals(this, o);
    }

    public Collection<Resolvable> toResolve() {
        return this.toResolve;
    }

    private static String jvmdowngrader$toString$toString(PlayerSelector playerSelector) {
        PlayerSelector playerSelector2 = playerSelector;
        return "PlayerSelector[" + "toResolve=" + playerSelector.toResolve + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(PlayerSelector playerSelector) {
        Object[] objectArray = new Object[]{playerSelector.toResolve};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(PlayerSelector playerSelector, Object object) {
        if (playerSelector == object) {
            return true;
        }
        if (object != null && object instanceof PlayerSelector) {
            PlayerSelector playerSelector2 = (PlayerSelector)object;
            if (Objects.equals(playerSelector.toResolve, playerSelector2.toResolve)) {
                return true;
            }
        }
        return false;
    }

    @RecordComponents(value={@RecordComponents.Value(name="player", type=SRPlayer.class)})
    @NestHost(value=PlayerSelector.class)
    public static final class Player
    extends J_L_Record
    implements Resolvable {
        private final SRPlayer player;

        public Player(SRPlayer player) {
            this.player = player;
        }

        @Override
        public Collection<UUID> resolve(SRCommandSender commandSender) {
            return J_U_List.of(this.player.getUniqueId());
        }

        @Override
        public final String toString() {
            return Player.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Player.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Player.jvmdowngrader$equals$equals(this, o);
        }

        public SRPlayer player() {
            return this.player;
        }

        private static String jvmdowngrader$toString$toString(Player player) {
            Player player2 = player;
            return "PlayerSelector$Player[" + "player=" + player.player + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Player player) {
            Object[] objectArray = new Object[]{player.player};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Player player, Object object) {
            if (player == object) {
                return true;
            }
            if (object != null && object instanceof Player) {
                Player player2 = (Player)object;
                if (Objects.equals(player.player, player2.player)) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=PlayerSelector.class)
    public static interface Resolvable {
        public Collection<UUID> resolve(SRCommandSender var1);
    }

    @RecordComponents(value={@RecordComponents.Value(name="platform", type=SRPlatformAdapter.class), @RecordComponents.Value(name="type", type=SelectorType.class)})
    @NestHost(value=PlayerSelector.class)
    public static final class Selector
    extends J_L_Record
    implements Resolvable {
        private final SRPlatformAdapter platform;
        private final SelectorType type;

        public Selector(SRPlatformAdapter platform, SelectorType type) {
            this.platform = platform;
            this.type = type;
        }

        @Override
        public Collection<UUID> resolve(SRCommandSender commandSender) {
            List<UUID> list;
            switch (this.type.ordinal()) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case 0: {
                    list = J_U_S_Stream.toList(this.platform.getOnlinePlayers(commandSender).stream().map(SRPlayer::getUniqueId));
                    break;
                }
                case 1: {
                    list = J_U_List.of(SRHelpers.getRandomEntry(this.platform.getOnlinePlayers(commandSender)).getUniqueId());
                }
            }
            return list;
        }

        @Override
        public final String toString() {
            return Selector.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Selector.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Selector.jvmdowngrader$equals$equals(this, o);
        }

        public SRPlatformAdapter platform() {
            return this.platform;
        }

        public SelectorType type() {
            return this.type;
        }

        private static String jvmdowngrader$toString$toString(Selector selector) {
            Selector selector2 = selector;
            return "PlayerSelector$Selector[" + "platform=" + selector.platform + ", " + "type=" + (Object)((Object)selector.type) + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Selector selector) {
            Object[] objectArray = new Object[]{selector.platform, selector.type};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Selector selector, Object object) {
            if (selector == object) {
                return true;
            }
            if (object != null && object instanceof Selector) {
                Selector selector2 = (Selector)object;
                if (Objects.equals(selector.platform, selector2.platform) && Objects.equals((Object)selector.type, (Object)selector2.type)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="uniqueId", type=UUID.class)})
    @NestHost(value=PlayerSelector.class)
    public static final class UniqueId
    extends J_L_Record
    implements Resolvable {
        private final UUID uniqueId;

        public UniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public Collection<UUID> resolve(SRCommandSender commandSender) {
            return J_U_List.of(this.uniqueId);
        }

        @Override
        public final String toString() {
            return UniqueId.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return UniqueId.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return UniqueId.jvmdowngrader$equals$equals(this, o);
        }

        public UUID uniqueId() {
            return this.uniqueId;
        }

        private static String jvmdowngrader$toString$toString(UniqueId uniqueId) {
            UniqueId uniqueId2 = uniqueId;
            return "PlayerSelector$UniqueId[" + "uniqueId=" + uniqueId.uniqueId + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(UniqueId uniqueId) {
            Object[] objectArray = new Object[]{uniqueId.uniqueId};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(UniqueId uniqueId, Object object) {
            if (uniqueId == object) {
                return true;
            }
            if (object != null && object instanceof UniqueId) {
                UniqueId uniqueId2 = (UniqueId)object;
                if (Objects.equals(uniqueId.uniqueId, uniqueId2.uniqueId)) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=PlayerSelector.class)
    public static enum SelectorType {
        ALL_PLAYERS,
        RANDOM_PLAYER;

    }
}

