/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Greedy;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Quoted;
import net.skinsrestorer.shadow.cloud.annotations.Argument;
import net.skinsrestorer.shadow.cloud.annotations.Command;
import net.skinsrestorer.shadow.cloud.annotations.suggestion.Suggestions;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.help.result.CommandEntry;
import net.skinsrestorer.shadow.cloud.minecraft.extras.MinecraftHelp;
import net.skinsrestorer.shadow.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_TimeUnit;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.commands.library.PlayerSelector;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.commands.library.annotations.SRCooldownGroup;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.connections.RecommendationsState;
import net.skinsrestorer.shared.connections.responses.RecommenationResponse;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.model.player.FavouriteData;
import net.skinsrestorer.shared.storage.model.player.HistoryData;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.subjects.permissions.SkinPermissionManager;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.shared.utils.ValidationUtil;

@Command(value="skin")
@RootDescription(value=Message.HELP_SKIN)
public final class SkinCommand {
    public static final String COOLDOWN_GROUP_ID = "skin";
    public static final CooldownGroup COOLDOWN_GROUP = CooldownGroup.named("skin");
    private final SRPlatformAdapter adapter;
    private final SRPlugin plugin;
    private final SettingsManager settings;
    private final SkinStorageImpl skinStorage;
    private final PlayerStorageImpl playerStorage;
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;
    private final SharedSkinApplier<Object> skinApplier;
    private final MineSkinAPI mineSkinAPI;
    private final SRCommandManager commandManager;
    private final RecommendationsState recommendationsState;
    private final SkinPermissionManager permissionManager;

    @Command(value="")
    @CommandPermission(value=PermissionRegistry.SKIN)
    public void rootCommand(SRCommandSender sender) {
        if (this.settings.getProperty(CommandConfig.CUSTOM_HELP_ENABLED).booleanValue()) {
            this.settings.getProperty(CommandConfig.CUSTOM_HELP_MESSAGE).forEach(l -> sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(l, new TagResolver[0])));
            return;
        }
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/skin help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional.orElseThrow(Message.fromKey(d)), new TagResolver[0]))).commandFilter(c -> c.rootComponent().name().equals(COOLDOWN_GROUP_ID) && !c.commandDescription().description().isEmpty()).maxResultsPerPage(Integer.MAX_VALUE).build().queryCommands("", sender);
    }

    @Suggestions(value="help_queries_skin")
    public List<String> suggestHelpQueries(CommandContext<SRCommandSender> ctx, String input) {
        return J_U_S_Stream.toList(this.commandManager.getCommandManager().createHelpHandler().queryRootIndex(ctx.sender()).entries().stream().filter(e -> e.command().rootComponent().name().equals(COOLDOWN_GROUP_ID)).map(CommandEntry::syntax));
    }

    @Command(value="help [query]")
    @CommandPermission(value=PermissionRegistry.SKIN)
    @CommandDescription(value=Message.HELP_SKIN)
    public void commandHelp(SRCommandSender sender, @Argument(suggestions="help_queries_skin") @Greedy String query) {
        if (this.settings.getProperty(CommandConfig.CUSTOM_HELP_ENABLED).booleanValue()) {
            this.settings.getProperty(CommandConfig.CUSTOM_HELP_MESSAGE).forEach(l -> sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(l, new TagResolver[0])));
            return;
        }
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/skin help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional.orElseThrow(Message.fromKey(d)), new TagResolver[0]))).commandFilter(c -> c.rootComponent().name().equals(COOLDOWN_GROUP_ID) && !c.commandDescription().description().isEmpty()).build().queryCommands(query == null ? "" : query, sender);
    }

    @Command(value="<skinName>")
    @CommandPermission(value=PermissionRegistry.SKIN_SET)
    @CommandDescription(value=Message.HELP_SKIN_SET)
    @SRCooldownGroup(value="skin")
    private void onSkinSetShort(SRPlayer player, @Quoted String skinName) {
        this.onSkinSetOther(player, skinName, PlayerSelector.singleton(player), null);
    }

    @Command(value="<skinName> <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_SET_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_SET_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinSetShortOther(SRPlayer player, @Quoted String skinName, PlayerSelector selector) {
        this.onSkinSetOther(player, skinName, selector, null);
    }

    @Command(value="clear|reset")
    @CommandPermission(value=PermissionRegistry.SKIN_CLEAR)
    @CommandDescription(value=Message.HELP_SKIN_CLEAR)
    @SRCooldownGroup(value="skin")
    private void onSkinClear(SRPlayer player) {
        this.onSkinClearOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="clear|reset <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_CLEAR_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_CLEAR_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinClearOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            this.playerStorage.removeSkinIdOfPlayer(target);
            try {
                if (targetPlayer.isPresent()) {
                    Optional<SkinProperty> property = this.playerStorage.getSkinForPlayer(target, targetPlayer.get().getName());
                    this.skinApplier.applySkin(targetPlayer.get().getAs(Object.class), property.orElse(PropertyUtils.EMPTY_SKIN));
                }
                if (this.senderEqual(sender, target)) {
                    sender.sendMessage(Message.SUCCESS_SKIN_CLEAR, new TagResolver[0]);
                    continue;
                }
                sender.sendMessage(Message.SUCCESS_SKIN_CLEAR_OTHER, Placeholder.unparsed("name", targetName));
            }
            catch (DataRequestException e) {
                this.logger.severe("Error while clearing skin", e);
                sender.sendMessage(Message.ERROR_UPDATING_SKIN, new TagResolver[0]);
            }
        }
    }

    @Command(value="random")
    @CommandPermission(value=PermissionRegistry.SKIN_RANDOM)
    @CommandDescription(value=Message.HELP_SKIN_RANDOM)
    @SRCooldownGroup(value="skin")
    private void onSkinRandom(SRPlayer player) {
        this.onSkinRandomOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="random <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_RANDOM_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_RANDOM_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinRandomOther(SRCommandSender sender, PlayerSelector selector) {
        Optional<RecommenationResponse.SkinInfo> randomRecommendation = this.recommendationsState.getRandomRecommendation();
        if (J_U_Optional.isEmpty(randomRecommendation)) {
            this.logger.warning("No random skins available, skipping");
            return;
        }
        this.onSkinSetOther(sender, SkinCommand.jvmdowngrader$concat$onSkinRandomOther$1(randomRecommendation.get().getSkinId()), selector);
    }

    @Command(value="search <searchString>")
    @CommandPermission(value=PermissionRegistry.SKIN_SEARCH)
    @CommandDescription(value=Message.HELP_SKIN_SEARCH)
    @SRCooldownGroup(value="skin")
    private void onSkinSearch(SRCommandSender sender, @Greedy String searchString) {
        sender.sendMessage(Message.SKIN_SEARCH_MESSAGE, Placeholder.unparsed("search", searchString));
    }

    @Command(value="edit")
    @CommandPermission(value=PermissionRegistry.SKIN_EDIT)
    @CommandDescription(value=Message.HELP_SKIN_EDIT)
    @SRCooldownGroup(value="skin")
    private void onSkinEdit(SRPlayer player) {
        player.sendMessage(Message.SKIN_EDIT_MESSAGE, Placeholder.parsed("url", J_L_String.formatted("https://minecraft.novaskin.me/?skin=%s", PropertyUtils.getSkinTextureUrl(this.adapter.getSkinProperty(player).orElse(HardcodedSkins.STEVE.getProperty())))));
    }

    @Command(value="update|refresh")
    @CommandPermission(value=PermissionRegistry.SKIN_UPDATE)
    @CommandDescription(value=Message.HELP_SKIN_UPDATE)
    @SRCooldownGroup(value="skin")
    private void onSkinUpdate(SRPlayer player) {
        this.onSkinUpdateOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="update|refresh <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_UPDATE_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_UPDATE_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinUpdateOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            try {
                Optional<SkinIdentifier> currentSkin;
                Optional<SkinIdentifier> optional = currentSkin = targetPlayer.isPresent() ? this.playerStorage.getSkinIdForPlayer(target, targetPlayer.get().getName()) : this.playerStorage.getSkinIdOfPlayer(target);
                if (currentSkin.isPresent() && currentSkin.get().getSkinType() == SkinType.PLAYER && J_U_Optional.isEmpty(this.skinStorage.updatePlayerSkinData(currentSkin.get().getPlayerUniqueId()))) {
                    sender.sendMessage(Message.ERROR_UPDATING_SKIN, new TagResolver[0]);
                    return;
                }
                if (targetPlayer.isPresent()) {
                    Optional<SkinProperty> newSkin = J_U_Optional.isEmpty(currentSkin) ? Optional.empty() : this.playerStorage.getSkinForPlayer(target, targetPlayer.get().getName());
                    this.skinApplier.applySkin(targetPlayer.get().getAs(Object.class), newSkin.orElse(PropertyUtils.EMPTY_SKIN));
                }
                if (this.senderEqual(sender, target)) {
                    sender.sendMessage(Message.SUCCESS_UPDATING_SKIN, new TagResolver[0]);
                } else {
                    sender.sendMessage(Message.SUCCESS_UPDATING_SKIN_OTHER, Placeholder.unparsed("name", targetName));
                }
                this.setCoolDown(sender, CommandConfig.SKIN_CHANGE_COOLDOWN);
            }
            catch (DataRequestException e) {
                ComponentHelper.sendException(e, sender, this.locale, this.logger);
                this.setCoolDown(sender, CommandConfig.SKIN_ERROR_COOLDOWN);
            }
        }
    }

    @Command(value="set|select <skinName>")
    @CommandPermission(value=PermissionRegistry.SKIN_SET)
    @CommandDescription(value=Message.HELP_SKIN_SET)
    @SRCooldownGroup(value="skin")
    private void onSkinSet(SRPlayer player, @Quoted String skinName) {
        this.onSkinSetOther(player, skinName, PlayerSelector.singleton(player));
    }

    @Command(value="set|select <skinName> <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_SET_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_SET_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinSetOther(SRCommandSender sender, @Quoted String skinName, PlayerSelector selector) {
        this.onSkinSetOther(sender, skinName, selector, null);
    }

    @Command(value="set|select <skinName> <selector> <skinVariant>")
    @CommandPermission(value=PermissionRegistry.SKIN_SET_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_SET_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinSetOther(SRCommandSender sender, @Quoted String skinName, PlayerSelector selector, SkinVariant skinVariant) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            if (!this.setSkin(sender, target, skinName, skinVariant, true)) {
                return;
            }
            if (this.senderEqual(sender, target)) {
                sender.sendMessage(Message.SUCCESS_SKIN_CHANGE, Placeholder.unparsed(COOLDOWN_GROUP_ID, skinName));
                continue;
            }
            sender.sendMessage(Message.SUCCESS_SKIN_CHANGE_OTHER, Placeholder.unparsed("name", targetName), Placeholder.unparsed(COOLDOWN_GROUP_ID, skinName));
        }
    }

    @Command(value="url <url> [skinVariant]")
    @CommandPermission(value=PermissionRegistry.SKIN_SET_URL)
    @CommandDescription(value=Message.HELP_SKIN_SET_URL)
    @SRCooldownGroup(value="skin")
    private void onSkinSetUrl(SRPlayer player, @Quoted String url, @Nullable SkinVariant skinVariant) {
        if (!ValidationUtil.validSkinUrl(url)) {
            player.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
            return;
        }
        this.onSkinSetOther(player, url, PlayerSelector.singleton(player), skinVariant);
    }

    @Command(value="undo|revert")
    @CommandPermission(value=PermissionRegistry.SKIN_UNDO)
    @CommandDescription(value=Message.HELP_SKIN_UNDO)
    @SRCooldownGroup(value="skin")
    private void onSkinUndo(SRPlayer player) {
        this.onSkinUndoOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="undo|revert <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_UNDO_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_UNDO_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinUndoOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            Optional<HistoryData> historyData = this.playerStorage.getTopOfHistory(target, 0);
            if (J_U_Optional.isEmpty(historyData)) {
                sender.sendMessage(Message.ERROR_NO_UNDO, new TagResolver[0]);
                return;
            }
            Optional<SkinIdentifier> currentSkin = this.playerStorage.getSkinIdOfPlayer(target);
            if (currentSkin.isPresent() && currentSkin.get().equals(historyData.get().getSkinIdentifier())) {
                Optional<HistoryData> historyData2 = this.playerStorage.getTopOfHistory(target, 1);
                if (J_U_Optional.isEmpty(historyData2)) {
                    sender.sendMessage(Message.ERROR_NO_UNDO, new TagResolver[0]);
                    return;
                }
                this.playerStorage.removeFromHistory(target, historyData.get());
                historyData = historyData2;
            }
            if (!this.setSkin(sender, target, historyData.get().getSkinIdentifier().getIdentifier(), historyData.get().getSkinIdentifier().getSkinVariant(), false)) {
                return;
            }
            if (this.senderEqual(sender, target)) {
                sender.sendMessage(Message.SUCCESS_SKIN_UNDO, Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(historyData.get().getSkinIdentifier()))), Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, historyData.get().getTimestamp(), sender.getLocale())));
                continue;
            }
            sender.sendMessage(Message.SUCCESS_SKIN_UNDO_OTHER, Placeholder.unparsed("name", targetName), Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(historyData.get().getSkinIdentifier()))), Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, historyData.get().getTimestamp(), sender.getLocale())));
        }
    }

    @Command(value="history")
    @CommandPermission(value=PermissionRegistry.SKIN_UNDO)
    @CommandDescription(value=Message.HELP_SKIN_UNDO)
    @SRCooldownGroup(value="skin")
    private void onSkinHistory(SRPlayer player) {
        this.onSkinHistoryOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="history <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_UNDO_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_UNDO_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinHistoryOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            List<HistoryData> historyDataList = this.playerStorage.getHistoryEntries(target, 0, Integer.MAX_VALUE);
            if (historyDataList.isEmpty()) {
                sender.sendMessage(Message.ERROR_NO_HISTORY, new TagResolver[0]);
                return;
            }
            sender.sendMessage(Message.DIVIDER, new TagResolver[0]);
            for (HistoryData historyData : historyDataList) {
                sender.sendMessage(Message.SUCCESS_HISTORY_LINE, Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, historyData.getTimestamp(), sender.getLocale())), Placeholder.parsed("skin_id", historyData.getSkinIdentifier().getIdentifier()), Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(historyData.getSkinIdentifier()))));
            }
            sender.sendMessage(Message.DIVIDER, new TagResolver[0]);
        }
    }

    @Command(value="favourite")
    @CommandPermission(value=PermissionRegistry.SKIN_FAVOURITE)
    @CommandDescription(value=Message.HELP_SKIN_FAVOURITE)
    @SRCooldownGroup(value="skin")
    private void onSkinFavourite(SRPlayer player) {
        this.onSkinFavouriteOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="favourite <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_FAVOURITE_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_FAVOURITE_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinFavouriteOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            Optional<SkinIdentifier> currentSkin = this.playerStorage.getSkinIdOfPlayer(target);
            if (J_U_Optional.isEmpty(currentSkin)) {
                sender.sendMessage(Message.ERROR_NO_SKIN_TO_FAVOURITE, new TagResolver[0]);
                return;
            }
            Optional<FavouriteData> favouriteData = this.playerStorage.getFavouriteData(target, currentSkin.get());
            if (favouriteData.isPresent()) {
                this.playerStorage.removeFavourite(target, favouriteData.get().getSkinIdentifier());
                if (this.senderEqual(sender, target)) {
                    sender.sendMessage(Message.SUCCESS_SKIN_UNFAVOURITE, Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(currentSkin.get()))), Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, favouriteData.get().getTimestamp(), sender.getLocale())));
                    continue;
                }
                sender.sendMessage(Message.SUCCESS_SKIN_UNFAVOURITE_OTHER, Placeholder.unparsed("name", targetName), Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(currentSkin.get()))), Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, favouriteData.get().getTimestamp(), sender.getLocale())));
                continue;
            }
            this.playerStorage.addFavourite(target, FavouriteData.of(SRHelpers.getEpochSecond(), currentSkin.get()));
            if (this.senderEqual(sender, target)) {
                sender.sendMessage(Message.SUCCESS_SKIN_FAVOURITE, Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(currentSkin.get()))));
                continue;
            }
            sender.sendMessage(Message.SUCCESS_SKIN_FAVOURITE_OTHER, Placeholder.unparsed("name", targetName), Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(currentSkin.get()))));
        }
    }

    @Command(value="favourites")
    @CommandPermission(value=PermissionRegistry.SKIN_FAVOURITE)
    @CommandDescription(value=Message.HELP_SKIN_FAVOURITE)
    @SRCooldownGroup(value="skin")
    private void onSkinFavourites(SRPlayer player) {
        this.onSkinFavouritesOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="favourites <selector>")
    @CommandPermission(value=PermissionRegistry.SKIN_FAVOURITE_OTHER)
    @CommandDescription(value=Message.HELP_SKIN_FAVOURITE_OTHER)
    @SRCooldownGroup(value="skin")
    private void onSkinFavouritesOther(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            List<FavouriteData> favouriteDataList = this.playerStorage.getFavouriteEntries(target, 0, Integer.MAX_VALUE);
            if (favouriteDataList.isEmpty()) {
                sender.sendMessage(Message.ERROR_NO_HISTORY, new TagResolver[0]);
                return;
            }
            sender.sendMessage(Message.DIVIDER, new TagResolver[0]);
            for (FavouriteData favouriteData : favouriteDataList) {
                sender.sendMessage(Message.SUCCESS_HISTORY_LINE, Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, favouriteData.getTimestamp(), sender.getLocale())), Placeholder.parsed("skin_id", favouriteData.getSkinIdentifier().getIdentifier()), Placeholder.component(COOLDOWN_GROUP_ID, ComponentHelper.convertJsonToComponent(this.skinStorage.resolveSkinName(favouriteData.getSkinIdentifier()))));
            }
            sender.sendMessage(Message.DIVIDER, new TagResolver[0]);
        }
    }

    @Command(value="menu|gui")
    @CommandPermission(value=PermissionRegistry.SKINS)
    private void onGUIShortcut(SRPlayer player) {
        this.commandManager.execute(player, "skins");
    }

    private boolean setSkin(SRCommandSender sender, UUID target, String skinInput, SkinVariant skinVariant, boolean insertHistory) {
        Optional<Message> noPermissionMessage = this.permissionManager.canSetSkin(sender, skinInput);
        if (noPermissionMessage.isPresent()) {
            sender.sendMessage(noPermissionMessage.get(), new TagResolver[0]);
            return false;
        }
        try {
            Optional<InputDataResult> optional;
            if (ValidationUtil.validSkinUrl(skinInput)) {
                sender.sendMessage(Message.MS_UPLOADING_SKIN, new TagResolver[0]);
            }
            if (J_U_Optional.isEmpty(optional = this.skinStorage.findOrCreateSkinData(skinInput, skinVariant))) {
                sender.sendMessage(Message.NOT_PREMIUM, new TagResolver[0]);
                return false;
            }
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            this.playerStorage.setSkinIdOfPlayer(target, optional.get().getIdentifier());
            targetPlayer.ifPresent(player -> this.skinApplier.applySkin(player.getAs(Object.class), ((InputDataResult)optional.get()).getProperty()));
            this.setCoolDown(sender, CommandConfig.SKIN_CHANGE_COOLDOWN);
            if (insertHistory && targetPlayer.isPresent() && this.senderEqual(sender, target)) {
                this.playerStorage.pushToHistory(target, HistoryData.of(SRHelpers.getEpochSecond(), optional.get().getIdentifier()));
            }
            return true;
        }
        catch (DataRequestException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
        catch (MineSkinException e) {
            this.logger.debug(SRLogLevel.SEVERE, J_L_String.formatted("Could not generate skin url: %s", skinInput), e);
            sender.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
        }
        this.setCoolDown(sender, CommandConfig.SKIN_ERROR_COOLDOWN);
        return false;
    }

    private void setCoolDown(SRCommandSender sender, Property<Integer> time) {
        if (sender instanceof SRPlayer) {
            SRPlayer player = (SRPlayer)sender;
            this.commandManager.setCooldown(player, COOLDOWN_GROUP, Duration.of(this.settings.getProperty(time).intValue(), J_U_C_TimeUnit.toChronoUnit(TimeUnit.SECONDS)));
        }
    }

    private boolean senderEqual(SRCommandSender sender, UUID other) {
        if (sender instanceof SRPlayer) {
            SRPlayer player = (SRPlayer)sender;
            return player.getUniqueId().equals(other);
        }
        return false;
    }

    @Inject
    @Generated
    public SkinCommand(SRPlatformAdapter adapter, SRPlugin plugin, SettingsManager settings, SkinStorageImpl skinStorage, PlayerStorageImpl playerStorage, SkinsRestorerLocale locale, SRLogger logger, SharedSkinApplier<Object> skinApplier, MineSkinAPI mineSkinAPI, SRCommandManager commandManager, RecommendationsState recommendationsState, SkinPermissionManager permissionManager) {
        this.adapter = adapter;
        this.plugin = plugin;
        this.settings = settings;
        this.skinStorage = skinStorage;
        this.playerStorage = playerStorage;
        this.locale = locale;
        this.logger = logger;
        this.skinApplier = skinApplier;
        this.mineSkinAPI = mineSkinAPI;
        this.commandManager = commandManager;
        this.recommendationsState = recommendationsState;
        this.permissionManager = permissionManager;
    }

    private static String jvmdowngrader$concat$onSkinRandomOther$1(String string) {
        return "sr-recommendation-" + string;
    }
}

