/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.codec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.codec.BuiltInCodecs;
import net.skinsrestorer.shared.codec.NetworkCodec;
import net.skinsrestorer.shared.codec.NetworkId;
import net.skinsrestorer.shared.codec.SROutputWriter;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="channelPayload", type=ChannelPayload.class)})
@NestMembers(value={GiveSkullChannelPayload.class, SkinUpdateChannelPayload.class, GUIPageChannelPayload.class, ChannelPayload.class, ChannelType.class})
public final class SRServerPluginMessage
extends J_L_Record {
    private final ChannelPayload<?> channelPayload;
    public static final NetworkCodec<SRServerPluginMessage> CODEC = NetworkCodec.of((out, msg) -> {
        ChannelType.CODEC.write(out, msg.channelPayload().getType());
        msg.channelPayload().writeCodec(out);
    }, in -> new SRServerPluginMessage((ChannelPayload)ChannelType.CODEC.read(in).codec().read(in)));

    public SRServerPluginMessage(ChannelPayload<?> channelPayload) {
        this.channelPayload = channelPayload;
    }

    @Override
    public final String toString() {
        return SRServerPluginMessage.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return SRServerPluginMessage.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return SRServerPluginMessage.jvmdowngrader$equals$equals(this, o);
    }

    public ChannelPayload<?> channelPayload() {
        return this.channelPayload;
    }

    private static String jvmdowngrader$toString$toString(SRServerPluginMessage sRServerPluginMessage) {
        SRServerPluginMessage sRServerPluginMessage2 = sRServerPluginMessage;
        return "SRServerPluginMessage[" + "channelPayload=" + sRServerPluginMessage.channelPayload + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(SRServerPluginMessage sRServerPluginMessage) {
        Object[] objectArray = new Object[]{sRServerPluginMessage.channelPayload};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(SRServerPluginMessage sRServerPluginMessage, Object object) {
        if (sRServerPluginMessage == object) {
            return true;
        }
        if (object != null && object instanceof SRServerPluginMessage) {
            SRServerPluginMessage sRServerPluginMessage2 = (SRServerPluginMessage)object;
            if (Objects.equals(sRServerPluginMessage.channelPayload, sRServerPluginMessage2.channelPayload)) {
                return true;
            }
        }
        return false;
    }

    @NestHost(value=SRServerPluginMessage.class)
    public static interface ChannelPayload<T extends ChannelPayload<T>> {
        public ChannelType<T> getType();

        public T cast();

        default public void writeCodec(SROutputWriter out) {
            this.getType().codec().write(out, this.cast());
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="channelName", type=String.class), @RecordComponents.Value(name="codec", type=NetworkCodec.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class ChannelType<T extends ChannelPayload<T>>
    extends J_L_Record
    implements NetworkId {
        private final String channelName;
        private final NetworkCodec<T> codec;
        private static final Map<String, ChannelType<?>> ID_TO_VALUE = new HashMap();
        public static final ChannelType<GUIPageChannelPayload> OPEN_GUI = ChannelType.register(new ChannelType<GUIPageChannelPayload>("openGUI", GUIPageChannelPayload.CODEC));
        public static final ChannelType<SkinUpdateChannelPayload> SKIN_UPDATE = ChannelType.register(new ChannelType<SkinUpdateChannelPayload>("SkinUpdateV2", SkinUpdateChannelPayload.CODEC));
        public static final ChannelType<GiveSkullChannelPayload> GIVE_SKULL = ChannelType.register(new ChannelType<GiveSkullChannelPayload>("giveSkull", GiveSkullChannelPayload.CODEC));
        public static final NetworkCodec<ChannelType<?>> CODEC = NetworkCodec.ofMapBackedDynamic(ID_TO_VALUE, NetworkId::getId, arg_0 -> ChannelType.lambda$static$0("Unknown channel type: %s (Make sure the server and proxy are running the same version of SkinsRestorer)", arg_0));

        public ChannelType(String channelName, NetworkCodec<T> codec) {
            this.channelName = channelName;
            this.codec = codec;
        }

        private static <T extends ChannelPayload<T>> ChannelType<T> register(ChannelType<T> channelType) {
            ID_TO_VALUE.put(channelType.getId(), channelType);
            return channelType;
        }

        @Override
        public String getId() {
            return this.channelName;
        }

        @Override
        public final String toString() {
            return ChannelType.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ChannelType.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ChannelType.jvmdowngrader$equals$equals(this, o);
        }

        public String channelName() {
            return this.channelName;
        }

        public NetworkCodec<T> codec() {
            return this.codec;
        }

        private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
            return J_L_String.formatted("Unknown channel type: %s (Make sure the server and proxy are running the same version of SkinsRestorer)", xva$0);
        }

        private static String jvmdowngrader$toString$toString(ChannelType channelType) {
            ChannelType channelType2 = channelType;
            return "SRServerPluginMessage$ChannelType[" + "channelName=" + channelType.channelName + ", " + "codec=" + channelType.codec + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ChannelType channelType) {
            Object[] objectArray = new Object[]{channelType.channelName, channelType.codec};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ChannelType channelType, Object object) {
            if (channelType == object) {
                return true;
            }
            if (object != null && object instanceof ChannelType) {
                ChannelType channelType2 = (ChannelType)object;
                if (Objects.equals(channelType.channelName, channelType2.channelName) && Objects.equals(channelType.codec, channelType2.codec)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="displayName", type=ComponentString.class), @RecordComponents.Value(name="textureHash", type=String.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class GiveSkullChannelPayload
    extends J_L_Record
    implements ChannelPayload<GiveSkullChannelPayload> {
        private final ComponentString displayName;
        private final String textureHash;
        public static final NetworkCodec<GiveSkullChannelPayload> CODEC = NetworkCodec.of((out, msg) -> {
            ComponentString.CODEC.write(out, msg.displayName());
            BuiltInCodecs.STRING_CODEC.write(out, msg.textureHash());
        }, in -> new GiveSkullChannelPayload(ComponentString.CODEC.read(in), BuiltInCodecs.STRING_CODEC.read(in)));

        public GiveSkullChannelPayload(ComponentString displayName, String textureHash) {
            this.displayName = displayName;
            this.textureHash = textureHash;
        }

        @Override
        public ChannelType<GiveSkullChannelPayload> getType() {
            return ChannelType.GIVE_SKULL;
        }

        @Override
        public GiveSkullChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return GiveSkullChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GiveSkullChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GiveSkullChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public ComponentString displayName() {
            return this.displayName;
        }

        public String textureHash() {
            return this.textureHash;
        }

        private static String jvmdowngrader$toString$toString(GiveSkullChannelPayload giveSkullChannelPayload) {
            GiveSkullChannelPayload giveSkullChannelPayload2 = giveSkullChannelPayload;
            return "SRServerPluginMessage$GiveSkullChannelPayload[" + "displayName=" + giveSkullChannelPayload.displayName + ", " + "textureHash=" + giveSkullChannelPayload.textureHash + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(GiveSkullChannelPayload giveSkullChannelPayload) {
            Object[] objectArray = new Object[]{giveSkullChannelPayload.displayName, giveSkullChannelPayload.textureHash};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(GiveSkullChannelPayload giveSkullChannelPayload, Object object) {
            if (giveSkullChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof GiveSkullChannelPayload) {
                GiveSkullChannelPayload giveSkullChannelPayload2 = (GiveSkullChannelPayload)object;
                if (Objects.equals(giveSkullChannelPayload.displayName, giveSkullChannelPayload2.displayName) && Objects.equals(giveSkullChannelPayload.textureHash, giveSkullChannelPayload2.textureHash)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="skinProperty", type=SkinProperty.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class SkinUpdateChannelPayload
    extends J_L_Record
    implements ChannelPayload<SkinUpdateChannelPayload> {
        private final SkinProperty skinProperty;
        public static final NetworkCodec<SkinUpdateChannelPayload> CODEC = NetworkCodec.of((out, msg) -> BuiltInCodecs.SKIN_PROPERTY_CODEC.write(out, msg.skinProperty()), in -> new SkinUpdateChannelPayload(BuiltInCodecs.SKIN_PROPERTY_CODEC.read(in)));

        public SkinUpdateChannelPayload(SkinProperty skinProperty) {
            this.skinProperty = skinProperty;
        }

        @Override
        public ChannelType<SkinUpdateChannelPayload> getType() {
            return ChannelType.SKIN_UPDATE;
        }

        @Override
        public SkinUpdateChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return SkinUpdateChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return SkinUpdateChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return SkinUpdateChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public SkinProperty skinProperty() {
            return this.skinProperty;
        }

        private static String jvmdowngrader$toString$toString(SkinUpdateChannelPayload skinUpdateChannelPayload) {
            SkinUpdateChannelPayload skinUpdateChannelPayload2 = skinUpdateChannelPayload;
            return "SRServerPluginMessage$SkinUpdateChannelPayload[" + "skinProperty=" + skinUpdateChannelPayload.skinProperty + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(SkinUpdateChannelPayload skinUpdateChannelPayload) {
            Object[] objectArray = new Object[]{skinUpdateChannelPayload.skinProperty};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(SkinUpdateChannelPayload skinUpdateChannelPayload, Object object) {
            if (skinUpdateChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof SkinUpdateChannelPayload) {
                SkinUpdateChannelPayload skinUpdateChannelPayload2 = (SkinUpdateChannelPayload)object;
                if (Objects.equals(skinUpdateChannelPayload.skinProperty, skinUpdateChannelPayload2.skinProperty)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="srInventory", type=SRInventory.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class GUIPageChannelPayload
    extends J_L_Record
    implements ChannelPayload<GUIPageChannelPayload> {
        private final SRInventory srInventory;
        public static final NetworkCodec<GUIPageChannelPayload> CODEC = NetworkCodec.of((out, msg) -> SRInventory.CODEC.write(out, msg.srInventory()), in -> new GUIPageChannelPayload(SRInventory.CODEC.read(in)));

        public GUIPageChannelPayload(SRInventory srInventory) {
            this.srInventory = srInventory;
        }

        @Override
        public ChannelType<GUIPageChannelPayload> getType() {
            return ChannelType.OPEN_GUI;
        }

        @Override
        public GUIPageChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return GUIPageChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GUIPageChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GUIPageChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public SRInventory srInventory() {
            return this.srInventory;
        }

        private static String jvmdowngrader$toString$toString(GUIPageChannelPayload gUIPageChannelPayload) {
            GUIPageChannelPayload gUIPageChannelPayload2 = gUIPageChannelPayload;
            return "SRServerPluginMessage$GUIPageChannelPayload[" + "srInventory=" + gUIPageChannelPayload.srInventory + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(GUIPageChannelPayload gUIPageChannelPayload) {
            Object[] objectArray = new Object[]{gUIPageChannelPayload.srInventory};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(GUIPageChannelPayload gUIPageChannelPayload, Object object) {
            if (gUIPageChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof GUIPageChannelPayload) {
                GUIPageChannelPayload gUIPageChannelPayload2 = (GUIPageChannelPayload)object;
                if (Objects.equals(gUIPageChannelPayload.srInventory, gUIPageChannelPayload2.srInventory)) {
                    return true;
                }
            }
            return false;
        }
    }
}

