/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.codec;

import java.util.Locale;
import java.util.Optional;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shared.codec.NetworkCodec;
import net.skinsrestorer.shared.codec.SRInputReader;
import net.skinsrestorer.shared.codec.SROutputWriter;

public class BuiltInCodecs {
    public static final NetworkCodec<String> STRING_CODEC = NetworkCodec.of(SROutputWriter::writeString, SRInputReader::readString);
    public static final NetworkCodec<Integer> INT_CODEC = NetworkCodec.of(SROutputWriter::writeInt, SRInputReader::readInt);
    public static final NetworkCodec<Boolean> BOOLEAN_CODEC = NetworkCodec.of(SROutputWriter::writeBoolean, SRInputReader::readBoolean);
    public static final NetworkCodec<SkinProperty> SKIN_PROPERTY_CODEC = NetworkCodec.of((os, s) -> {
        STRING_CODEC.write(os, s.getValue());
        STRING_CODEC.write(os, s.getSignature());
    }, is -> SkinProperty.of(STRING_CODEC.read(is), STRING_CODEC.read(is)));
    public static final NetworkCodec<SkinVariant> SKIN_VARIANT_CODEC = NetworkCodec.ofEnumDynamic(SkinVariant.class, t -> t.name().toLowerCase(Locale.ROOT));
    public static final NetworkCodec<SkinType> SKIN_TYPE_CODEC = NetworkCodec.ofEnumDynamic(SkinType.class, t -> t.name().toLowerCase(Locale.ROOT));
    public static final NetworkCodec<SkinIdentifier> SKIN_IDENTIFIER_CODEC = NetworkCodec.of((os, s) -> {
        STRING_CODEC.write(os, s.getIdentifier());
        SKIN_VARIANT_CODEC.optional().write(os, Optional.ofNullable(s.getSkinVariant()));
        SKIN_TYPE_CODEC.write(os, s.getSkinType());
    }, is -> SkinIdentifier.of(STRING_CODEC.read(is), SKIN_VARIANT_CODEC.optional().read(is).orElse(null), SKIN_TYPE_CODEC.read(is)));
}

