/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api.event;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import lombok.Generated;
import net.skinsrestorer.api.event.EventBus;
import net.skinsrestorer.api.event.SkinsRestorerEvent;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.api.event.EventSubscription;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;

public class EventBusImpl
implements EventBus {
    private final Queue<EventSubscription<?>> subscriptions = new ConcurrentLinkedQueue();
    private final SRPlatformAdapter platformAdapter;
    private final SRLogger logger;

    @Override
    public <E extends SkinsRestorerEvent> void subscribe(Object plugin, Class<E> eventClass, Consumer<E> listener) {
        this.platformAdapter.extendLifeTime(plugin, listener);
        this.subscriptions.add(new EventSubscription<E>(new WeakReference<Object>(plugin), eventClass, new WeakReference<Consumer<E>>(listener)));
    }

    public void callEvent(SkinsRestorerEvent event) {
        this.subscriptions.removeIf(subscription -> subscription.plugin().get() == null || subscription.listener().get() == null);
        for (EventSubscription eventSubscription : this.subscriptions) {
            try {
                eventSubscription.callEvent(event);
            }
            catch (Throwable t) {
                this.logger.severe(J_L_String.formatted("Error while calling event %s", event.getClass().getSimpleName()), t);
            }
        }
    }

    @Inject
    @Generated
    public EventBusImpl(SRPlatformAdapter platformAdapter, SRLogger logger) {
        this.platformAdapter = platformAdapter;
        this.logger = logger;
    }
}

