/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.reflection.jvm.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Contract;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jbannotations.Unmodifiable;
import net.skinsrestorer.shadow.xseries.reflection.XAccessFlag;
import net.skinsrestorer.shadow.xseries.reflection.jvm.objects.ReflectedObjectClass;
import net.skinsrestorer.shadow.xseries.reflection.jvm.objects.ReflectedObjectConstructor;
import net.skinsrestorer.shadow.xseries.reflection.jvm.objects.ReflectedObjectField;
import net.skinsrestorer.shadow.xseries.reflection.jvm.objects.ReflectedObjectMethod;

@ApiStatus.Experimental
public interface ReflectedObject
extends AnnotatedElement {
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static ReflectedObject of(@NotNull Class<?> clazz) {
        return new ReflectedObjectClass(Objects.requireNonNull(clazz));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static ReflectedObject of(@NotNull Constructor<?> constructor) {
        return new ReflectedObjectConstructor(Objects.requireNonNull(constructor));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static ReflectedObject of(@NotNull Method method) {
        return new ReflectedObjectMethod(Objects.requireNonNull(method));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static ReflectedObject of(@NotNull Field field) {
        return new ReflectedObjectField(Objects.requireNonNull(field));
    }

    @NotNull
    @Contract(pure=true)
    public Object unreflect();

    @NotNull
    @Contract(pure=true)
    public Type type();

    @NotNull
    @Contract(pure=true)
    public String name();

    @Nullable
    @Contract(pure=true)
    public Class<?> getDeclaringClass();

    @Contract(pure=true)
    public int getModifiers();

    @NotNull
    @Contract(value="-> new", pure=true)
    default public @Unmodifiable Set<XAccessFlag> accessFlags() {
        return Collections.unmodifiableSet(XAccessFlag.of(this.getModifiers()));
    }

    public static enum Type {
        CLASS,
        CONSTRUCTOR,
        METHOD,
        FIELD;

    }
}

