/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.reflection.jvm.classes;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.skinsrestorer.shadow.ijannotations.Pattern;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.xseries.reflection.ReflectiveNamespace;
import net.skinsrestorer.shadow.xseries.reflection.XReflection;
import net.skinsrestorer.shadow.xseries.reflection.jvm.NameableReflectiveHandle;
import net.skinsrestorer.shadow.xseries.reflection.jvm.classes.ClassHandle;
import net.skinsrestorer.shadow.xseries.reflection.jvm.classes.PackageHandle;
import net.skinsrestorer.shadow.xseries.reflection.minecraft.MinecraftMapping;

public class DynamicClassHandle
extends ClassHandle
implements NameableReflectiveHandle {
    protected ClassHandle parent;
    protected String packageName;
    protected final Set<String> classNames = new HashSet<String>(5);
    protected int array;

    public DynamicClassHandle(ReflectiveNamespace namespace) {
        super(namespace);
    }

    public DynamicClassHandle inPackage(@Pattern(value="(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") @NotNull String packageName) {
        Objects.requireNonNull(packageName, "Null package name");
        this.packageName = packageName;
        return this;
    }

    public DynamicClassHandle inPackage(@NotNull PackageHandle packageHandle) {
        return this.inPackage(packageHandle, "");
    }

    public DynamicClassHandle inPackage(@NotNull PackageHandle packageHandle, @Pattern(value="(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") @NotNull String packageName) {
        Objects.requireNonNull(packageHandle, "Null package handle type");
        Objects.requireNonNull(packageName, "Null package handle name");
        if (this.parent != null) {
            throw new IllegalStateException("Cannot change package of an inner class: " + packageHandle + " -> " + packageName);
        }
        this.packageName = packageHandle.getPackage(packageName);
        return this;
    }

    @Override
    public DynamicClassHandle map(MinecraftMapping mapping, String name) {
        return this.named(name);
    }

    @Override
    public DynamicClassHandle named(String ... classNames) {
        Objects.requireNonNull(classNames);
        for (String className : this.classNames) {
            Objects.requireNonNull(className, () -> "Cannot add null class name from: " + Arrays.toString(classNames) + " to " + this);
        }
        this.classNames.addAll(Arrays.asList(classNames));
        return this;
    }

    public String[] reflectClassNames() {
        if (this.parent == null) {
            Objects.requireNonNull(this.packageName, "Package name is null");
        }
        String[] classNames = new String[this.classNames.size()];
        Class parent = this.parent == null ? null : (Class)XReflection.of((Class)this.parent.unreflect()).asArray(0).unreflect();
        int i = 0;
        for (String className : this.classNames) {
            String clazz = parent == null ? this.packageName + '.' + className : parent.getName() + '$' + className;
            if (this.array != 0) {
                clazz = Strings.repeat((String)"[", (int)this.array) + 'L' + clazz + ';';
            }
            classNames[i++] = clazz;
        }
        return classNames;
    }

    @Override
    public DynamicClassHandle copy() {
        DynamicClassHandle handle = new DynamicClassHandle(this.namespace);
        handle.array = this.array;
        handle.parent = this.parent;
        handle.packageName = this.packageName;
        handle.classNames.addAll(this.classNames);
        return handle;
    }

    @Override
    public Class<?> reflect() throws ClassNotFoundException {
        String[] classNames = this.reflectClassNames();
        if (classNames.length == 0) {
            throw new IllegalStateException("No class name specified for " + this);
        }
        Throwable errors = null;
        for (String className : classNames) {
            try {
                return this.checkConstraints(Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                if (errors == null) {
                    errors = new ClassNotFoundException("None of the classes were found");
                }
                errors.addSuppressed(ex);
            }
        }
        throw (ClassNotFoundException)XReflection.relativizeSuppressedExceptions(errors);
    }

    @Override
    public DynamicClassHandle asArray(int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("Array dimension cannot be negative: " + dimension);
        }
        this.array = dimension;
        return this;
    }

    @Override
    public boolean isArray() {
        return this.array > 0;
    }

    @Override
    public Set<String> getPossibleNames() {
        return this.classNames;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.parent == null ? "" : this.parent + " -> ") + (this.parent == null ? this.packageName : (this.packageName == null ? "" : this.packageName)) + '(' + String.join((CharSequence)"|", this.classNames) + ')' + (this.array == 0 ? "" : "[" + this.array + ']') + " }";
    }
}

