/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.message;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.mariadb.BasePreparedStatement;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.result.CompleteResult;
import net.skinsrestorer.shadow.mariadb.client.result.StreamingResult;
import net.skinsrestorer.shadow.mariadb.client.result.UpdatableResult;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.util.ClosableLock;
import net.skinsrestorer.shadow.mariadb.client.util.Parameters;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.message.server.ErrorPacket;
import net.skinsrestorer.shadow.mariadb.message.server.OkPacket;

public interface ClientMessage {
    public static boolean validateLocalFileName(String sql, Parameters parameters, String fileName, Context context) {
        String reg = "^((\\s[--]|#).*(\\r\\n|\\r|\\n)|\\s*/\\*([^*]|\\*[^/])*\\*/|.)*\\s*LOAD\\s+(DATA|XML)\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+'" + Pattern.quote(fileName.replace("\\", "\\\\")) + "'";
        Pattern pattern = Pattern.compile(reg, 2);
        if (pattern.matcher(sql).find()) {
            return true;
        }
        if (parameters != null && (pattern = Pattern.compile("^((\\s[--]|#).*(\\r\\n|\\r|\\n)|\\s*/\\*([^*]|\\*[^/])*\\*/|.)*\\s*LOAD\\s+(DATA|XML)\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+\\?", 2)).matcher(sql).find() && parameters.size() > 0) {
            String paramString = parameters.get(0).bestEffortStringValue(context);
            if (paramString != null) {
                return paramString.equalsIgnoreCase("'" + fileName.replace("\\", "\\\\") + "'");
            }
            return true;
        }
        return false;
    }

    public int encode(Writer var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ClosableLock lock, boolean traceEnable, ClientMessage message, Consumer<String> redirectFct) throws IOException, SQLException {
        ColumnDecoder[] ci;
        ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
        switch (buf.getByte()) {
            case 0: {
                OkPacket ok = OkPacket.parse(buf, context);
                if (context.getRedirectUrl() != null && (context.getServerStatus() & 1) == 0 && (context.getServerStatus() & 8) == 0) {
                    redirectFct.accept(context.getRedirectUrl());
                }
                return ok;
            }
            case -1: {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case -5: {
                buf.skip(1);
                SQLException exception = null;
                reader.getSequence().set(writer.getSequence());
                InputStream is = this.getLocalInfileInputStream();
                if (is == null) {
                    String fileName = buf.readStringNullEnd();
                    if (!message.validateLocalFileName(fileName, context)) {
                        exception = exceptionFactory.withSql(this.description()).create(String.format("LOAD DATA LOCAL INFILE asked for file '%s' that doesn't correspond to initial query %s. Possible malicious proxy changing server answer ! Command interrupted", fileName, this.description()), "HY000");
                    } else {
                        try {
                            is = new FileInputStream(fileName);
                        }
                        catch (FileNotFoundException f) {
                            exception = exceptionFactory.withSql(this.description()).create("Could not send file : " + f.getMessage(), "HY000", f);
                        }
                    }
                }
                if (is != null) {
                    try {
                        int len;
                        byte[] fileBuf = new byte[8192];
                        while ((len = is.read(fileBuf)) > 0) {
                            writer.writeBytes(fileBuf, 0, len);
                            writer.flush();
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                writer.writeEmptyPacket();
                Completion completion = this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable, message, redirectFct);
                if (exception != null) {
                    throw exception;
                }
                return completion;
            }
        }
        int fieldCount = buf.readIntLengthEncodedNotNull();
        if (context.canSkipMeta() && this.canSkipMeta()) {
            if (buf.readByte() == 0) {
                ci = ((BasePreparedStatement)stmt).getMeta();
            } else {
                ci = new ColumnDecoder[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    ci[i] = context.getColumnDecoderFunction().apply(new StandardReadableByteBuf(reader.readPacket(traceEnable)));
                }
                ((BasePreparedStatement)stmt).updateMeta(ci);
            }
        } else {
            ci = new ColumnDecoder[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                ci[i] = context.getColumnDecoderFunction().apply(new StandardReadableByteBuf(reader.readPacket(traceEnable)));
            }
        }
        if (!context.isEofDeprecated()) {
            reader.skipPacket();
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize != 0) {
            if ((context.getServerStatus() & 8) > 0) {
                context.setServerStatus(context.getServerStatus() - 8);
            }
            return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
        }
        return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable, this.mightBeBulkResult());
    }

    default public InputStream getLocalInfileInputStream() {
        return null;
    }

    default public boolean mightBeBulkResult() {
        return false;
    }

    default public boolean validateLocalFileName(String fileName, Context context) {
        return false;
    }
}

