/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client;

import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.column.BigDecimalColumn;
import net.skinsrestorer.shadow.mariadb.client.column.BitColumn;
import net.skinsrestorer.shadow.mariadb.client.column.BlobColumn;
import net.skinsrestorer.shadow.mariadb.client.column.DateColumn;
import net.skinsrestorer.shadow.mariadb.client.column.DoubleColumn;
import net.skinsrestorer.shadow.mariadb.client.column.FloatColumn;
import net.skinsrestorer.shadow.mariadb.client.column.GeometryColumn;
import net.skinsrestorer.shadow.mariadb.client.column.JsonColumn;
import net.skinsrestorer.shadow.mariadb.client.column.SignedBigIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.SignedIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.SignedMediumIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.SignedSmallIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.SignedTinyIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.StringColumn;
import net.skinsrestorer.shadow.mariadb.client.column.TimeColumn;
import net.skinsrestorer.shadow.mariadb.client.column.TimestampColumn;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedBigIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedMediumIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedSmallIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedTinyIntColumn;
import net.skinsrestorer.shadow.mariadb.client.column.YearColumn;

public enum DataType {
    OLDDECIMAL(0, BigDecimalColumn::new, BigDecimalColumn::new),
    TINYINT(1, SignedTinyIntColumn::new, UnsignedTinyIntColumn::new),
    SMALLINT(2, SignedSmallIntColumn::new, UnsignedSmallIntColumn::new),
    INTEGER(3, SignedIntColumn::new, UnsignedIntColumn::new),
    FLOAT(4, FloatColumn::new, FloatColumn::new),
    DOUBLE(5, DoubleColumn::new, DoubleColumn::new),
    NULL(6, StringColumn::new, StringColumn::new),
    TIMESTAMP(7, TimestampColumn::new, TimestampColumn::new),
    BIGINT(8, SignedBigIntColumn::new, UnsignedBigIntColumn::new),
    MEDIUMINT(9, SignedMediumIntColumn::new, UnsignedMediumIntColumn::new),
    DATE(10, DateColumn::new, DateColumn::new),
    TIME(11, TimeColumn::new, TimeColumn::new),
    DATETIME(12, TimestampColumn::new, TimestampColumn::new),
    YEAR(13, YearColumn::new, YearColumn::new),
    NEWDATE(14, DateColumn::new, DateColumn::new),
    VARCHAR(15, StringColumn::new, StringColumn::new),
    BIT(16, BitColumn::new, BitColumn::new),
    JSON(245, JsonColumn::new, JsonColumn::new),
    DECIMAL(246, BigDecimalColumn::new, BigDecimalColumn::new),
    ENUM(247, StringColumn::new, StringColumn::new),
    SET(248, StringColumn::new, StringColumn::new),
    TINYBLOB(249, BlobColumn::new, BlobColumn::new),
    MEDIUMBLOB(250, BlobColumn::new, BlobColumn::new),
    LONGBLOB(251, BlobColumn::new, BlobColumn::new),
    BLOB(252, BlobColumn::new, BlobColumn::new),
    VARSTRING(253, StringColumn::new, StringColumn::new),
    STRING(254, StringColumn::new, StringColumn::new),
    GEOMETRY(255, GeometryColumn::new, GeometryColumn::new);

    static final DataType[] typeMap;
    private final int mariadbType;
    private final ColumnConstructor columnConstructor;
    private final ColumnConstructor unsignedColumnConstructor;

    private DataType(int mariadbType, ColumnConstructor columnConstructor, ColumnConstructor unsignedColumnConstructor) {
        this.mariadbType = mariadbType;
        this.columnConstructor = columnConstructor;
        this.unsignedColumnConstructor = unsignedColumnConstructor;
    }

    public static DataType of(int typeValue) {
        return typeMap[typeValue];
    }

    public int get() {
        return this.mariadbType;
    }

    public ColumnConstructor getColumnConstructor() {
        return this.columnConstructor;
    }

    public ColumnConstructor getUnsignedColumnConstructor() {
        return this.unsignedColumnConstructor;
    }

    static {
        typeMap = new DataType[256];
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DataType v;
            DataType.typeMap[v.mariadbType] = v = dataTypeArray[i];
        }
    }

    @FunctionalInterface
    public static interface ColumnConstructor {
        public ColumnDecoder create(ReadableByteBuf var1, int var2, long var3, DataType var5, byte var6, int var7, int[] var8, String var9, String var10);
    }
}

