/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.Column;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.column.UuidColumn;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;

public interface ColumnDecoder
extends Column {
    public static ColumnDecoder decodeStd(ReadableByteBuf buf) {
        int[] stringPos = new int[]{buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier()};
        buf.skipIdentifier();
        buf.skip();
        short charset = buf.readShort();
        int length = buf.readInt();
        DataType dataType = DataType.of(buf.readUnsignedByte());
        int flags = buf.readUnsignedShort();
        byte decimals = buf.readByte();
        DataType.ColumnConstructor constructor = (flags & 0x20) == 0 ? dataType.getColumnConstructor() : dataType.getUnsignedColumnConstructor();
        return constructor.create(buf, charset, length, dataType, decimals, flags, stringPos, null, null);
    }

    public static ColumnDecoder decode(ReadableByteBuf buf) {
        int[] stringPos = new int[]{buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier(), buf.skipIdentifier()};
        buf.skipIdentifier();
        String extTypeName = null;
        String extTypeFormat = null;
        if (buf.readByte() != 0) {
            buf.pos(buf.pos() - 1);
            ReadableByteBuf subPacket = buf.readLengthBuffer();
            block4: while (subPacket.readableBytes() > 0) {
                switch (subPacket.readByte()) {
                    case 0: {
                        extTypeName = subPacket.readAscii(subPacket.readLength());
                        continue block4;
                    }
                    case 1: {
                        extTypeFormat = subPacket.readAscii(subPacket.readLength());
                        continue block4;
                    }
                }
                subPacket.skip(subPacket.readLength());
            }
        }
        buf.skip();
        short charset = buf.readShort();
        int length = buf.readInt();
        DataType dataType = DataType.of(buf.readUnsignedByte());
        int flags = buf.readUnsignedShort();
        byte decimals = buf.readByte();
        DataType.ColumnConstructor constructor = extTypeName != null && extTypeName.equals("uuid") ? UuidColumn::new : ((flags & 0x20) == 0 ? dataType.getColumnConstructor() : dataType.getUnsignedColumnConstructor());
        return constructor.create(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    public static ColumnDecoder create(String name, DataType type, int flags) {
        int len;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[9 + 2 * nameBytes.length];
        arr[0] = 3;
        arr[1] = 68;
        arr[2] = 69;
        arr[3] = 70;
        int[] stringPos = new int[5];
        stringPos[0] = 4;
        stringPos[1] = 5;
        stringPos[2] = 6;
        int pos = 7;
        for (int i = 0; i < 2; ++i) {
            stringPos[i + 3] = pos;
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        switch (type) {
            case VARCHAR: 
            case VARSTRING: {
                len = 192;
                break;
            }
            case SMALLINT: {
                len = 5;
                break;
            }
            case NULL: {
                len = 0;
                break;
            }
            default: {
                len = 1;
            }
        }
        DataType.ColumnConstructor constructor = (flags & 0x20) == 0 ? type.getColumnConstructor() : type.getUnsignedColumnConstructor();
        return constructor.create(new StandardReadableByteBuf(arr, arr.length), 33, len, type, (byte)0, flags, stringPos, null, null);
    }

    public String defaultClassname(Configuration var1);

    public int getColumnType(Configuration var1);

    public String getColumnTypeName(Configuration var1);

    default public int getPrecision() {
        return (int)this.getColumnLength();
    }

    public Object getDefaultText(ReadableByteBuf var1, MutableInt var2, Context var3) throws SQLDataException;

    public Object getDefaultBinary(ReadableByteBuf var1, MutableInt var2, Context var3) throws SQLDataException;

    public String decodeStringText(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public String decodeStringBinary(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public byte decodeByteText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public byte decodeByteBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public Date decodeDateText(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public Date decodeDateBinary(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public Time decodeTimeText(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public Time decodeTimeBinary(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public Timestamp decodeTimestampText(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public Timestamp decodeTimestampBinary(ReadableByteBuf var1, MutableInt var2, Calendar var3, Context var4) throws SQLDataException;

    public boolean decodeBooleanText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public boolean decodeBooleanBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public short decodeShortText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public short decodeShortBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public int decodeIntText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public int decodeIntBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public long decodeLongText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public long decodeLongBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public float decodeFloatText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public float decodeFloatBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public double decodeDoubleText(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public double decodeDoubleBinary(ReadableByteBuf var1, MutableInt var2) throws SQLDataException;

    public ColumnDecoder useAliasAsName();
}

