/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.Driver;
import net.skinsrestorer.shadow.mariadb.MariaDbPoolConnection;
import net.skinsrestorer.shadow.mariadb.MariaDbPoolPinnedConnection;

public class MariaDbDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private Configuration conf = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private Integer loginTimeout = null;

    public MariaDbDataSource() {
    }

    public MariaDbDataSource(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong mariaDB url: %s", url));
        }
        this.url = url;
    }

    private void config() throws SQLException {
        if (this.url == null) {
            throw new SQLException("url not set");
        }
        this.conf = Configuration.parse(this.url);
        if (this.loginTimeout != null) {
            this.conf.connectTimeout(this.loginTimeout * 1000);
        }
        if (this.user != null || this.password != null) {
            this.conf = this.conf.clone(this.user, this.password);
        }
        if (this.user != null) {
            this.user = this.conf.user();
        }
        if (this.password != null) {
            this.password = this.conf.password();
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return Driver.connect(this.conf);
    }

    @Override
    public java.sql.Connection getConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        Configuration conf = this.conf.clone(username, password);
        return Driver.connect(conf);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Datasource is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.loginTimeout != null) {
            return this.loginTimeout;
        }
        if (this.conf != null) {
            return this.conf.connectTimeout() / 1000;
        }
        return DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() : 30;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
        if (this.conf != null) {
            this.config();
        }
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        Connection conn = Driver.connect(this.conf);
        MariaDbPoolConnection poolConnection = this.conf.pinGlobalTxToPhysicalConnection() ? new MariaDbPoolPinnedConnection(conn) : new MariaDbPoolConnection(conn);
        this.setConnectionCloseListener(poolConnection);
        return poolConnection;
    }

    @Override
    public PooledConnection getPooledConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        Configuration conf = this.conf.clone(username, password);
        Connection conn = Driver.connect(conf);
        MariaDbPoolConnection poolConnection = conf.pinGlobalTxToPhysicalConnection() ? new MariaDbPoolPinnedConnection(conn) : new MariaDbPoolConnection(conn);
        this.setConnectionCloseListener(poolConnection);
        return poolConnection;
    }

    private void setConnectionCloseListener(final MariaDbPoolConnection mariaDbPoolConnection) {
        mariaDbPoolConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
                try {
                    mariaDbPoolConnection.realClose();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return (MariaDbPoolConnection)this.getPooledConnection();
    }

    @Override
    public XAConnection getXAConnection(String username, String password) throws SQLException {
        return (MariaDbPoolConnection)this.getPooledConnection(username, password);
    }

    public String getUrl() {
        if (this.conf == null) {
            return this.url;
        }
        return this.conf.initialUrl();
    }

    public void setUrl(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong mariaDB url: %s", url));
        }
        this.url = url;
        this.config();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) throws SQLException {
        this.user = user;
        if (this.conf != null) {
            this.config();
        }
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
        if (this.conf != null) {
            this.config();
        }
    }
}

