/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.client.Client;
import net.skinsrestorer.shadow.mariadb.client.impl.MultiPrimaryClient;
import net.skinsrestorer.shadow.mariadb.client.impl.MultiPrimaryReplicaClient;
import net.skinsrestorer.shadow.mariadb.client.impl.ReplayClient;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardClient;
import net.skinsrestorer.shadow.mariadb.client.util.ClosableLock;
import net.skinsrestorer.shadow.mariadb.export.HaMode;
import net.skinsrestorer.shadow.mariadb.pool.Pools;
import net.skinsrestorer.shadow.mariadb.util.VersionFactory;

public final class Driver
implements java.sql.Driver {
    private static final Pattern identifierPattern = Pattern.compile("[0-9a-zA-Z$_\\u0080-\\uFFFF]*", 64);
    private static final Pattern escapePattern = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> mapper = new HashMap<String, String>();

    public static Connection connect(Configuration configuration) throws SQLException {
        ClosableLock lock = new ClosableLock();
        if (configuration.haMode() == HaMode.NONE) {
            ClientInstance<Configuration, HostAddress, ClosableLock, Boolean, Client> clientInstance;
            ClientInstance<Configuration, HostAddress, ClosableLock, Boolean, Client> clientInstance2 = clientInstance = configuration.transactionReplay() ? ReplayClient::new : StandardClient::new;
            if (configuration.addresses().isEmpty()) {
                throw new SQLException("host, pipe or local socket must be set to connect socket");
            }
            SQLException lastException = null;
            for (HostAddress host : configuration.addresses()) {
                try {
                    Client client = clientInstance.apply(configuration, host, lock, false);
                    return new Connection(configuration, lock, client);
                }
                catch (SQLException e) {
                    lastException = e;
                }
            }
            throw lastException;
        }
        MultiPrimaryClient client = configuration.havePrimaryHostOnly() ? new MultiPrimaryClient(configuration, lock) : new MultiPrimaryReplicaClient(configuration, lock);
        return new Connection(configuration, lock, client);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        Configuration configuration = Configuration.parse(url, props);
        if (configuration != null) {
            if (configuration.pool()) {
                return Pools.retrievePool(configuration).getPoolConnection().getConnection();
            }
            return Driver.connect(configuration);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return Configuration.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Configuration conf = Configuration.parse(url, info);
        if (conf == null) {
            return new DriverPropertyInfo[0];
        }
        Properties propDesc = new Properties();
        try (InputStream inputStream2 = Driver.class.getClassLoader().getResourceAsStream("driver.properties");){
            propDesc.load(inputStream2);
        }
        catch (IOException inputStream2) {
            // empty catch block
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        for (Field field : Configuration.Builder.class.getDeclaredFields()) {
            if (field.getName().startsWith("_")) continue;
            try {
                Method getterMethod = Configuration.class.getDeclaredMethod(field.getName(), new Class[0]);
                Object obj = getterMethod.invoke((Object)conf, new Object[0]);
                String value = obj == null ? null : obj.toString();
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value);
                propertyInfo.description = value == null ? "" : (String)propDesc.get(field.getName());
                propertyInfo.required = false;
                props.add(propertyInfo);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return props.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return VersionFactory.getInstance().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionFactory.getInstance().getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    public static String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        int len = identifier.length();
        if (Driver.isSimpleIdentifier(identifier)) {
            if (len < 1 || len > 64) {
                throw new SQLException("Invalid identifier length");
            }
            if (alwaysQuote) {
                return "`" + identifier + "`";
            }
            for (int i = 0; i < identifier.length(); ++i) {
                if (Character.isDigit(identifier.charAt(i))) continue;
                return identifier;
            }
            return "`" + identifier + "`";
        }
        if (identifier.contains("\u0000")) {
            throw new SQLException("Invalid name - containing u0000 character", "42000");
        }
        if (identifier.matches("^`.+`$")) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        if (len < 1 || len > 64) {
            throw new SQLException("Invalid identifier length");
        }
        return "`" + identifier.replace("`", "``") + "`";
    }

    public static String enquoteLiteral(String val) {
        Matcher matcher = escapePattern.matcher(val);
        StringBuffer escapedVal = new StringBuffer("'");
        while (matcher.find()) {
            matcher.appendReplacement(escapedVal, mapper.get(matcher.group()));
        }
        matcher.appendTail(escapedVal);
        escapedVal.append("'");
        return escapedVal.toString();
    }

    public static boolean isSimpleIdentifier(String identifier) {
        return identifier != null && !identifier.isEmpty() && identifierPattern.matcher(identifier).matches();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        mapper.put("\u0000", "\\0");
        mapper.put("'", "\\\\'");
        mapper.put("\"", "\\\\\"");
        mapper.put("\b", "\\\\b");
        mapper.put("\n", "\\\\n");
        mapper.put("\r", "\\\\r");
        mapper.put("\t", "\\\\t");
        mapper.put("\u001a", "\\\\Z");
        mapper.put("\\", "\\\\");
    }

    @FunctionalInterface
    private static interface ClientInstance<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4) throws SQLException;
    }
}

