/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.dependency;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.injector.context.ObjectIdentifier;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.javax.annotation.Nullable;

public class CyclicDependenciesDetector
implements Handler {
    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        ObjectIdentifier duplicateIdentifier = CyclicDependenciesDetector.findRepeatedIdentifier(context);
        if (duplicateIdentifier != null) {
            String traversalList = CyclicDependenciesDetector.buildParentsList(context);
            throw new InjectorException("Found cyclic dependency' - already traversed '" + duplicateIdentifier + "' (full traversal list: " + traversalList + " -> " + context.getIdentifier() + ")");
        }
        return null;
    }

    @Nullable
    private static ObjectIdentifier findRepeatedIdentifier(ResolutionContext context) {
        HashSet<Type> types = new HashSet<Type>();
        types.add(context.getIdentifier().getType());
        for (ResolutionContext parent : context.getParents()) {
            if (types.add(parent.getIdentifier().getType())) continue;
            return parent.getIdentifier();
        }
        return null;
    }

    private static String buildParentsList(ResolutionContext context) {
        return context.getParents().stream().map(ctx -> ctx.getIdentifier().getType().getTypeName()).collect(Collectors.joining(" -> "));
    }
}

