/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.context;

import java.util.ArrayList;
import java.util.List;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.context.ObjectIdentifier;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;

public class ResolutionContext {
    private final Injector injector;
    private final ObjectIdentifier originalIdentifier;
    private ObjectIdentifier identifier;
    private List<ResolutionContext> parents = new ArrayList<ResolutionContext>();

    public ResolutionContext(Injector injector, ObjectIdentifier identifier) {
        this.injector = injector;
        this.originalIdentifier = identifier;
        this.identifier = identifier;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public ObjectIdentifier getOriginalIdentifier() {
        return this.originalIdentifier;
    }

    public ObjectIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<ResolutionContext> getParents() {
        return this.parents;
    }

    public void setIdentifier(ObjectIdentifier identifier) {
        if (!this.originalIdentifier.getTypeAsClass().isAssignableFrom(identifier.getTypeAsClass())) {
            throw new InjectorException("New mapped class '" + identifier.getTypeAsClass() + "' is not a child of original class '" + this.originalIdentifier.getTypeAsClass() + "'");
        }
        this.identifier = identifier;
    }

    public ResolutionContext createChildContext(ObjectIdentifier identifier) {
        ResolutionContext child = new ResolutionContext(this.injector, identifier);
        child.parents.addAll(this.parents);
        child.parents.add(this);
        return child;
    }
}

