/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.InjectorConfig;
import net.skinsrestorer.shadow.injector.InjectorImpl;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.dependency.CyclicDependenciesDetector;
import net.skinsrestorer.shadow.injector.handlers.dependency.FactoryDependencyHandler;
import net.skinsrestorer.shadow.injector.handlers.dependency.SavedAnnotationsHandler;
import net.skinsrestorer.shadow.injector.handlers.dependency.SingletonStoreDependencyHandler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.DefaultInjectionProvider;
import net.skinsrestorer.shadow.injector.handlers.instantiation.ProviderHandler;
import net.skinsrestorer.shadow.injector.handlers.postconstruct.PostConstructMethodInvoker;
import net.skinsrestorer.shadow.injector.utils.InjectorUtils;

public class InjectorBuilder {
    private InjectorConfig config = new InjectorConfig();

    public static List<Handler> createDefaultHandlers(String rootPackage) {
        InjectorUtils.checkNotNull(rootPackage, "root package may not be null");
        return new ArrayList<Handler>(Arrays.asList(new SavedAnnotationsHandler(), new ProviderHandler(), new FactoryDependencyHandler(), new SingletonStoreDependencyHandler(), new CyclicDependenciesDetector(), new DefaultInjectionProvider(rootPackage), new PostConstructMethodInvoker()));
    }

    public static List<Handler> createInstantiationProviders(String rootPackage) {
        InjectorUtils.checkNotNull(rootPackage, "root package may not be null");
        return new ArrayList<Handler>(Arrays.asList(new ProviderHandler(), new FactoryDependencyHandler(), new SingletonStoreDependencyHandler(), new DefaultInjectionProvider(rootPackage)));
    }

    public InjectorBuilder addDefaultHandlers(String rootPackage) {
        return this.addHandlers(InjectorBuilder.createDefaultHandlers(rootPackage));
    }

    public InjectorBuilder addHandlers(Handler ... handlers) {
        return this.addHandlers(Arrays.asList(handlers));
    }

    public InjectorBuilder addHandlers(Collection<? extends Handler> handlers) {
        this.config.addHandlers(handlers);
        return this;
    }

    public Injector create() {
        return new InjectorImpl(this.config);
    }
}

