/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.resource;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.configme.resource.MapNormalizer;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class YamlFileReader
implements PropertyReader {
    private final Path path;
    private final Charset charset;
    @Nullable
    private final Map<String, Object> root;

    public YamlFileReader(@NotNull Path path) {
        this(path, StandardCharsets.UTF_8, true);
    }

    public YamlFileReader(@NotNull Path path, @NotNull Charset charset) {
        this(path, charset, true);
    }

    public YamlFileReader(@NotNull Path path, @NotNull Charset charset, boolean splitDotPaths) {
        this.path = path;
        this.charset = charset;
        this.root = this.loadFile(splitDotPaths);
    }

    @Deprecated
    public YamlFileReader(@NotNull File file) {
        this(file.toPath(), StandardCharsets.UTF_8);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull String path) {
        String[] keys;
        if (path.isEmpty()) {
            return this.root;
        }
        Object node = this.root;
        for (String key : keys = path.split("\\.")) {
            if ((node = YamlFileReader.getEntryIfIsMap(key, node)) != null) continue;
            return null;
        }
        return node;
    }

    @Override
    @Nullable
    public String getString(@NotNull String path) {
        return this.getTypedObject(path, String.class);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String path) {
        Number n = this.getTypedObject(path, Number.class);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull String path) {
        Number n = this.getTypedObject(path, Number.class);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String path) {
        return this.getTypedObject(path, Boolean.class);
    }

    @Override
    @Nullable
    public List<?> getList(@NotNull String path) {
        return this.getTypedObject(path, List.class);
    }

    @Override
    public boolean contains(@NotNull String path) {
        return this.getObject(path) != null;
    }

    @Override
    @NotNull
    public Set<String> getKeys(boolean onlyLeafNodes) {
        if (this.root == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> allKeys = new LinkedHashSet<String>();
        this.collectKeysIntoSet("", this.root, allKeys, onlyLeafNodes);
        return allKeys;
    }

    @Override
    @NotNull
    public Set<String> getChildKeys(@NotNull String path) {
        Object object = this.getObject(path);
        if (object instanceof Map) {
            String pathPrefix = path.isEmpty() ? "" : path + ".";
            return ((Map)object).keySet().stream().map(childPath -> pathPrefix + childPath).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    private void collectKeysIntoSet(@NotNull String path, @NotNull Map<String, Object> map, @NotNull Set<String> result, boolean onlyLeafNodes) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String childPath;
            String string = childPath = path.isEmpty() ? entry.getKey() : path + "." + entry.getKey();
            if (!onlyLeafNodes || YamlFileReader.isLeafValue(entry.getValue())) {
                result.add(childPath);
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.collectKeysIntoSet(childPath, (Map)entry.getValue(), result, onlyLeafNodes);
        }
    }

    private static boolean isLeafValue(@Nullable Object o) {
        return !(o instanceof Map) || ((Map)o).isEmpty();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    protected Map<String, Object> loadFile(boolean splitDotPaths) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    protected Map<String, Object> normalizeMap(@Nullable Map<Object, Object> map, boolean splitDotPaths) {
        return new MapNormalizer(splitDotPaths).normalizeMap(map);
    }

    @Deprecated
    @NotNull
    protected final File getFile() {
        return this.path.toFile();
    }

    @NotNull
    protected final Path getPath() {
        return this.path;
    }

    @Deprecated
    @Nullable
    protected final Map<String, Object> getRoot() {
        return this.root;
    }

    @Nullable
    protected <T> T getTypedObject(@NotNull String path, @NotNull Class<T> clazz) {
        Object value = this.getObject(path);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Nullable
    private static Object getEntryIfIsMap(@NotNull String key, @Nullable Object value) {
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        return null;
    }
}

