/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.properties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.properties.BaseProperty;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class RegexProperty
extends BaseProperty<Pattern> {
    public RegexProperty(@NotNull String path, @NotNull Pattern defaultValue) {
        super(path, defaultValue);
    }

    public RegexProperty(@NotNull String path, @NotNull String defaultRegexValue) {
        this(path, Pattern.compile(defaultRegexValue));
    }

    @Override
    @Nullable
    protected Pattern getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        String pattern = reader.getString(this.getPath());
        if (pattern != null) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(@NotNull Pattern value) {
        return value.pattern();
    }

    public boolean matches(@NotNull String value, @NotNull SettingsManager settingsManager) {
        Matcher matcher = settingsManager.getProperty(this).matcher(value);
        return matcher.matches();
    }
}

