/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.beanmapper.propertydescription;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.skinsrestorer.shadow.configme.beanmapper.ConfigMeMapperException;
import net.skinsrestorer.shadow.configme.beanmapper.propertydescription.BeanPropertyDescription;
import net.skinsrestorer.shadow.configme.utils.TypeInformation;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class BeanPropertyDescriptionImpl
implements BeanPropertyDescription {
    private final String name;
    private final TypeInformation typeInformation;
    private final Method getter;
    private final Method setter;

    public BeanPropertyDescriptionImpl(@NotNull String name, @NotNull TypeInformation typeInformation, @NotNull Method getter, @NotNull Method setter) {
        this.name = name;
        this.typeInformation = typeInformation;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    @Nullable
    public Object getValue(@NotNull Object bean) {
        try {
            return this.getter.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not get property '" + this.name + "' from instance '" + bean + "'", e);
        }
    }

    @Override
    public void setValue(@NotNull Object bean, @NotNull Object value) {
        try {
            this.setter.invoke(bean, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not set property '" + this.name + "' to value '" + value + "' on instance '" + bean + "'", e);
        }
    }

    @NotNull
    public String toString() {
        return "Bean property '" + this.name + "' with getter '" + this.getter + "'";
    }
}

