/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.beanmapper.leafvaluehandler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.skinsrestorer.shadow.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import net.skinsrestorer.shadow.configme.utils.TypeInformation;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class CombiningLeafValueHandler
implements LeafValueHandler {
    @NotNull
    private final Collection<LeafValueHandler> handlers;

    public CombiningLeafValueHandler(LeafValueHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public CombiningLeafValueHandler(@NotNull Collection<LeafValueHandler> handlers) {
        this.handlers = Collections.unmodifiableCollection(handlers);
    }

    @Override
    @Nullable
    public Object convert(@NotNull TypeInformation typeInformation, @Nullable Object value) {
        return this.getFirstNonNull(t -> t.convert(typeInformation, value));
    }

    @Override
    @Nullable
    public Object toExportValue(@Nullable Object value) {
        return this.getFirstNonNull(t -> t.toExportValue(value));
    }

    @NotNull
    protected final Collection<LeafValueHandler> getHandlers() {
        return this.handlers;
    }

    @Nullable
    private Object getFirstNonNull(@NotNull Function<LeafValueHandler, Object> callback) {
        return this.handlers.stream().map(callback).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

