/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme;

import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.migration.MigrationService;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.configme.resource.PropertyResource;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class SettingsManagerImpl
implements SettingsManager {
    private final ConfigurationData configurationData;
    private final PropertyResource resource;
    private final MigrationService migrationService;

    protected SettingsManagerImpl(@NotNull PropertyResource resource, @NotNull ConfigurationData configurationData, @Nullable MigrationService migrationService) {
        this.configurationData = configurationData;
        this.resource = resource;
        this.migrationService = migrationService;
        this.loadFromResourceAndValidate();
    }

    @Override
    public <T> T getProperty(@NotNull Property<T> property) {
        return this.configurationData.getValue(property);
    }

    @Override
    public <T> void setProperty(@NotNull Property<T> property, @NotNull T value) {
        this.configurationData.setValue(property, value);
    }

    @Override
    public void reload() {
        this.loadFromResourceAndValidate();
    }

    @Override
    public void save() {
        this.resource.exportProperties(this.configurationData);
    }

    protected void loadFromResourceAndValidate() {
        PropertyReader reader = this.resource.createReader();
        this.configurationData.initializeValues(reader);
        if (this.migrationService != null && this.migrationService.checkAndMigrate(reader, this.configurationData)) {
            this.save();
        }
    }

    @NotNull
    protected final PropertyResource getPropertyResource() {
        return this.resource;
    }

    @NotNull
    protected final ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    @Nullable
    protected final MigrationService getMigrationService() {
        return this.migrationService;
    }
}

