/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.velocity.parser;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.cloud.caption.CaptionVariable;
import net.skinsrestorer.shadow.cloud.component.CommandComponent;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.context.CommandInput;
import net.skinsrestorer.shadow.cloud.exception.parsing.ParserException;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParseResult;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParser;
import net.skinsrestorer.shadow.cloud.parser.ParserDescriptor;
import net.skinsrestorer.shadow.cloud.suggestion.BlockingSuggestionProvider;
import net.skinsrestorer.shadow.cloud.velocity.VelocityCaptionKeys;
import net.skinsrestorer.shadow.cloud.velocity.VelocityContextKeys;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ServerParser<C>
implements ArgumentParser<C, RegisteredServer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, RegisteredServer> serverParser() {
        return ParserDescriptor.of(new ServerParser<C>(), RegisteredServer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, RegisteredServer> serverComponent() {
        return CommandComponent.builder().parser(ServerParser.serverParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull RegisteredServer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        RegisteredServer server = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getServer(input).orElse(null);
        if (server == null) {
            return ArgumentParseResult.failure(new ServerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(server);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllServers().stream().map(s -> s.getServerInfo().getName()).collect(Collectors.toList());
    }

    public static final class ServerParseException
    extends ParserException {
        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, CaptionVariable.of("input", input));
        }
    }
}

