/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.velocity.parser;

import com.mojang.brigadier.Message;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.proxy.Player;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.cloud.brigadier.suggestion.TooltipSuggestion;
import net.skinsrestorer.shadow.cloud.caption.CaptionVariable;
import net.skinsrestorer.shadow.cloud.component.CommandComponent;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.context.CommandInput;
import net.skinsrestorer.shadow.cloud.exception.parsing.ParserException;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParseResult;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParser;
import net.skinsrestorer.shadow.cloud.parser.ParserDescriptor;
import net.skinsrestorer.shadow.cloud.suggestion.BlockingSuggestionProvider;
import net.skinsrestorer.shadow.cloud.suggestion.Suggestion;
import net.skinsrestorer.shadow.cloud.velocity.VelocityCaptionKeys;
import net.skinsrestorer.shadow.cloud.velocity.VelocityContextKeys;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Player> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getPlayer(input).orElse(null);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllPlayers().stream().map(player -> TooltipSuggestion.suggestion(player.getUsername(), (Message)VelocityBrigadierMessage.tooltip((Component)Component.text((String)player.getUniqueId().toString())))).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

